/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.streams.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.dynamodb.model.DescribeStreamRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeStreamResponse;
import software.amazon.awssdk.services.dynamodb.model.Shard;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsClient;

public class DescribeStreamIterable
implements SdkIterable<DescribeStreamResponse> {
    private final DynamoDbStreamsClient client;
    private final DescribeStreamRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeStreamIterable(DynamoDbStreamsClient client, DescribeStreamRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeStreamResponseFetcher();
    }

    public Iterator<DescribeStreamResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Shard> shards() {
        Function<DescribeStreamResponse, Iterator> getIterator = response -> {
            if (response != null && response.streamDescription() != null && response.streamDescription().shards() != null) {
                return response.streamDescription().shards().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeStreamIterable resume(DescribeStreamResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeStreamIterable(this.client, (DescribeStreamRequest)((Object)this.firstRequest.toBuilder().exclusiveStartShardId(lastSuccessfulPage.streamDescription().lastEvaluatedShardId()).build()));
        }
        return new DescribeStreamIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeStreamResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeStreamResponseFetcher
    implements SyncPageFetcher<DescribeStreamResponse> {
        private DescribeStreamResponseFetcher() {
        }

        public boolean hasNextPage(DescribeStreamResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.streamDescription().lastEvaluatedShardId());
        }

        public DescribeStreamResponse nextPage(DescribeStreamResponse previousPage) {
            if (previousPage == null) {
                return DescribeStreamIterable.this.client.describeStream(DescribeStreamIterable.this.firstRequest);
            }
            return DescribeStreamIterable.this.client.describeStream((DescribeStreamRequest)((Object)DescribeStreamIterable.this.firstRequest.toBuilder().exclusiveStartShardId(previousPage.streamDescription().lastEvaluatedShardId()).build()));
        }
    }
}

