/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.util.Date;
import java.util.Map;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.StreamRecord;

@SdkInternalApi
public class StreamRecordMarshaller {
    private static final MarshallingInfo<Date> APPROXIMATECREATIONDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApproximateCreationDateTime").build();
    private static final MarshallingInfo<Map> KEYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Keys").build();
    private static final MarshallingInfo<Map> NEWIMAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NewImage").build();
    private static final MarshallingInfo<Map> OLDIMAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OldImage").build();
    private static final MarshallingInfo<String> SEQUENCENUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SequenceNumber").build();
    private static final MarshallingInfo<Long> SIZEBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SizeBytes").build();
    private static final MarshallingInfo<String> STREAMVIEWTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamViewType").build();
    private static final StreamRecordMarshaller instance = new StreamRecordMarshaller();

    public static StreamRecordMarshaller getInstance() {
        return instance;
    }

    public void marshall(StreamRecord streamRecord, ProtocolMarshaller protocolMarshaller) {
        if (streamRecord == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)streamRecord.approximateCreationDateTime(), APPROXIMATECREATIONDATETIME_BINDING);
            protocolMarshaller.marshall(streamRecord.keys(), KEYS_BINDING);
            protocolMarshaller.marshall(streamRecord.newImage(), NEWIMAGE_BINDING);
            protocolMarshaller.marshall(streamRecord.oldImage(), OLDIMAGE_BINDING);
            protocolMarshaller.marshall((Object)streamRecord.sequenceNumber(), SEQUENCENUMBER_BINDING);
            protocolMarshaller.marshall((Object)streamRecord.sizeBytes(), SIZEBYTES_BINDING);
            protocolMarshaller.marshall((Object)streamRecord.streamViewType(), STREAMVIEWTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

