/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexDescription;

@SdkInternalApi
public class LocalSecondaryIndexDescriptionMarshaller {
    private static final MarshallingInfo<String> INDEXNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IndexName").build();
    private static final MarshallingInfo<List> KEYSCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeySchema").build();
    private static final MarshallingInfo<StructuredPojo> PROJECTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Projection").build();
    private static final MarshallingInfo<Long> INDEXSIZEBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IndexSizeBytes").build();
    private static final MarshallingInfo<Long> ITEMCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ItemCount").build();
    private static final MarshallingInfo<String> INDEXARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IndexArn").build();
    private static final LocalSecondaryIndexDescriptionMarshaller instance = new LocalSecondaryIndexDescriptionMarshaller();

    public static LocalSecondaryIndexDescriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(LocalSecondaryIndexDescription localSecondaryIndexDescription, ProtocolMarshaller protocolMarshaller) {
        if (localSecondaryIndexDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)localSecondaryIndexDescription.indexName(), INDEXNAME_BINDING);
            protocolMarshaller.marshall(localSecondaryIndexDescription.keySchema(), KEYSCHEMA_BINDING);
            protocolMarshaller.marshall((Object)localSecondaryIndexDescription.projection(), PROJECTION_BINDING);
            protocolMarshaller.marshall((Object)localSecondaryIndexDescription.indexSizeBytes(), INDEXSIZEBYTES_BINDING);
            protocolMarshaller.marshall((Object)localSecondaryIndexDescription.itemCount(), ITEMCOUNT_BINDING);
            protocolMarshaller.marshall((Object)localSecondaryIndexDescription.indexArn(), INDEXARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

