/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.nio.ByteBuffer;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class AttributeValueUnmarshaller
implements Unmarshaller<AttributeValue, JsonUnmarshallerContext> {
    private static AttributeValueUnmarshaller INSTANCE;

    public AttributeValue unmarshall(JsonUnmarshallerContext context) throws Exception {
        AttributeValue.Builder attributeValueBuilder = AttributeValue.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("S", targetDepth)) {
                    context.nextToken();
                    attributeValueBuilder.s((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("N", targetDepth)) {
                    context.nextToken();
                    attributeValueBuilder.n((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("B", targetDepth)) {
                    context.nextToken();
                    attributeValueBuilder.b((ByteBuffer)context.getUnmarshaller(ByteBuffer.class).unmarshall((Object)context));
                }
                if (context.testExpression("SS", targetDepth)) {
                    context.nextToken();
                    attributeValueBuilder.ss(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("NS", targetDepth)) {
                    context.nextToken();
                    attributeValueBuilder.ns(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("BS", targetDepth)) {
                    context.nextToken();
                    attributeValueBuilder.bs(new ListUnmarshaller(context.getUnmarshaller(ByteBuffer.class)).unmarshall(context));
                }
                if (context.testExpression("M", targetDepth)) {
                    context.nextToken();
                    attributeValueBuilder.m(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)AttributeValueUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("L", targetDepth)) {
                    context.nextToken();
                    attributeValueBuilder.l(new ListUnmarshaller((Unmarshaller)AttributeValueUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("BOOL", targetDepth)) {
                    context.nextToken();
                    attributeValueBuilder.bool((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("NULL", targetDepth)) {
                    context.nextToken();
                    attributeValueBuilder.nul((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (AttributeValue)attributeValueBuilder.build();
    }

    public static AttributeValueUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AttributeValueUnmarshaller();
        }
        return INSTANCE;
    }
}

