/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
public class AttributeValueMarshaller {
    private static final MarshallingInfo<String> S_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S").build();
    private static final MarshallingInfo<String> N_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("N").build();
    private static final MarshallingInfo<ByteBuffer> B_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("B").build();
    private static final MarshallingInfo<List> SS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SS").build();
    private static final MarshallingInfo<List> NS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NS").build();
    private static final MarshallingInfo<List> BS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BS").build();
    private static final MarshallingInfo<Map> M_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("M").build();
    private static final MarshallingInfo<List> L_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("L").build();
    private static final MarshallingInfo<Boolean> BOOL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BOOL").build();
    private static final MarshallingInfo<Boolean> NUL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NULL").build();
    private static final AttributeValueMarshaller instance = new AttributeValueMarshaller();

    public static AttributeValueMarshaller getInstance() {
        return instance;
    }

    public void marshall(AttributeValue attributeValue, ProtocolMarshaller protocolMarshaller) {
        if (attributeValue == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)attributeValue.s(), S_BINDING);
            protocolMarshaller.marshall((Object)attributeValue.n(), N_BINDING);
            protocolMarshaller.marshall((Object)attributeValue.b(), B_BINDING);
            protocolMarshaller.marshall(attributeValue.ss(), SS_BINDING);
            protocolMarshaller.marshall(attributeValue.ns(), NS_BINDING);
            protocolMarshaller.marshall(attributeValue.bs(), BS_BINDING);
            protocolMarshaller.marshall(attributeValue.m(), M_BINDING);
            protocolMarshaller.marshall(attributeValue.l(), L_BINDING);
            protocolMarshaller.marshall((Object)attributeValue.bool(), BOOL_BINDING);
            protocolMarshaller.marshall((Object)attributeValue.nul(), NUL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

