/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.Identity;
import software.amazon.awssdk.services.dynamodb.model.OperationType;
import software.amazon.awssdk.services.dynamodb.model.StreamRecord;
import software.amazon.awssdk.services.dynamodb.transform.RecordMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Record
implements StructuredPojo,
ToCopyableBuilder<Builder, Record> {
    private final String eventID;
    private final String eventName;
    private final String eventVersion;
    private final String eventSource;
    private final String awsRegion;
    private final StreamRecord dynamodb;
    private final Identity userIdentity;

    private Record(BuilderImpl builder) {
        this.eventID = builder.eventID;
        this.eventName = builder.eventName;
        this.eventVersion = builder.eventVersion;
        this.eventSource = builder.eventSource;
        this.awsRegion = builder.awsRegion;
        this.dynamodb = builder.dynamodb;
        this.userIdentity = builder.userIdentity;
    }

    public String eventID() {
        return this.eventID;
    }

    public String eventName() {
        return this.eventName;
    }

    public String eventVersion() {
        return this.eventVersion;
    }

    public String eventSource() {
        return this.eventSource;
    }

    public String awsRegion() {
        return this.awsRegion;
    }

    public StreamRecord dynamodb() {
        return this.dynamodb;
    }

    public Identity userIdentity() {
        return this.userIdentity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.eventID() == null ? 0 : this.eventID().hashCode());
        hashCode = 31 * hashCode + (this.eventName() == null ? 0 : this.eventName().hashCode());
        hashCode = 31 * hashCode + (this.eventVersion() == null ? 0 : this.eventVersion().hashCode());
        hashCode = 31 * hashCode + (this.eventSource() == null ? 0 : this.eventSource().hashCode());
        hashCode = 31 * hashCode + (this.awsRegion() == null ? 0 : this.awsRegion().hashCode());
        hashCode = 31 * hashCode + (this.dynamodb() == null ? 0 : this.dynamodb().hashCode());
        hashCode = 31 * hashCode + (this.userIdentity() == null ? 0 : this.userIdentity().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Record)) {
            return false;
        }
        Record other = (Record)obj;
        if (other.eventID() == null ^ this.eventID() == null) {
            return false;
        }
        if (other.eventID() != null && !other.eventID().equals(this.eventID())) {
            return false;
        }
        if (other.eventName() == null ^ this.eventName() == null) {
            return false;
        }
        if (other.eventName() != null && !other.eventName().equals(this.eventName())) {
            return false;
        }
        if (other.eventVersion() == null ^ this.eventVersion() == null) {
            return false;
        }
        if (other.eventVersion() != null && !other.eventVersion().equals(this.eventVersion())) {
            return false;
        }
        if (other.eventSource() == null ^ this.eventSource() == null) {
            return false;
        }
        if (other.eventSource() != null && !other.eventSource().equals(this.eventSource())) {
            return false;
        }
        if (other.awsRegion() == null ^ this.awsRegion() == null) {
            return false;
        }
        if (other.awsRegion() != null && !other.awsRegion().equals(this.awsRegion())) {
            return false;
        }
        if (other.dynamodb() == null ^ this.dynamodb() == null) {
            return false;
        }
        if (other.dynamodb() != null && !other.dynamodb().equals(this.dynamodb())) {
            return false;
        }
        if (other.userIdentity() == null ^ this.userIdentity() == null) {
            return false;
        }
        return other.userIdentity() == null || other.userIdentity().equals(this.userIdentity());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.eventID() != null) {
            sb.append("EventID: ").append(this.eventID()).append(",");
        }
        if (this.eventName() != null) {
            sb.append("EventName: ").append(this.eventName()).append(",");
        }
        if (this.eventVersion() != null) {
            sb.append("EventVersion: ").append(this.eventVersion()).append(",");
        }
        if (this.eventSource() != null) {
            sb.append("EventSource: ").append(this.eventSource()).append(",");
        }
        if (this.awsRegion() != null) {
            sb.append("AwsRegion: ").append(this.awsRegion()).append(",");
        }
        if (this.dynamodb() != null) {
            sb.append("Dynamodb: ").append(this.dynamodb()).append(",");
        }
        if (this.userIdentity() != null) {
            sb.append("UserIdentity: ").append(this.userIdentity()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String eventID;
        private String eventName;
        private String eventVersion;
        private String eventSource;
        private String awsRegion;
        private StreamRecord dynamodb;
        private Identity userIdentity;

        private BuilderImpl() {
        }

        private BuilderImpl(Record model) {
            this.setEventID(model.eventID);
            this.setEventName(model.eventName);
            this.setEventVersion(model.eventVersion);
            this.setEventSource(model.eventSource);
            this.setAwsRegion(model.awsRegion);
            this.setDynamodb(model.dynamodb);
            this.setUserIdentity(model.userIdentity);
        }

        public final String getEventID() {
            return this.eventID;
        }

        @Override
        public final Builder eventID(String eventID) {
            this.eventID = eventID;
            return this;
        }

        public final void setEventID(String eventID) {
            this.eventID = eventID;
        }

        public final String getEventName() {
            return this.eventName;
        }

        @Override
        public final Builder eventName(String eventName) {
            this.eventName = eventName;
            return this;
        }

        @Override
        public final Builder eventName(OperationType eventName) {
            this.eventName(eventName.toString());
            return this;
        }

        public final void setEventName(String eventName) {
            this.eventName = eventName;
        }

        public final void setEventName(OperationType eventName) {
            this.eventName(eventName.toString());
        }

        public final String getEventVersion() {
            return this.eventVersion;
        }

        @Override
        public final Builder eventVersion(String eventVersion) {
            this.eventVersion = eventVersion;
            return this;
        }

        public final void setEventVersion(String eventVersion) {
            this.eventVersion = eventVersion;
        }

        public final String getEventSource() {
            return this.eventSource;
        }

        @Override
        public final Builder eventSource(String eventSource) {
            this.eventSource = eventSource;
            return this;
        }

        public final void setEventSource(String eventSource) {
            this.eventSource = eventSource;
        }

        public final String getAwsRegion() {
            return this.awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        public final StreamRecord getDynamodb() {
            return this.dynamodb;
        }

        @Override
        public final Builder dynamodb(StreamRecord dynamodb) {
            this.dynamodb = dynamodb;
            return this;
        }

        public final void setDynamodb(StreamRecord dynamodb) {
            this.dynamodb = dynamodb;
        }

        public final Identity getUserIdentity() {
            return this.userIdentity;
        }

        @Override
        public final Builder userIdentity(Identity userIdentity) {
            this.userIdentity = userIdentity;
            return this;
        }

        public final void setUserIdentity(Identity userIdentity) {
            this.userIdentity = userIdentity;
        }

        public Record build() {
            return new Record(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Record> {
        public Builder eventID(String var1);

        public Builder eventName(String var1);

        public Builder eventName(OperationType var1);

        public Builder eventVersion(String var1);

        public Builder eventSource(String var1);

        public Builder awsRegion(String var1);

        public Builder dynamodb(StreamRecord var1);

        public Builder userIdentity(Identity var1);
    }
}

