/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.dynamodb.model.Stream;
import software.amazon.awssdk.services.dynamodb.model.StreamListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListStreamsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListStreamsResponse> {
    private final List<Stream> streams;
    private final String lastEvaluatedStreamArn;

    private ListStreamsResponse(BuilderImpl builder) {
        this.streams = builder.streams;
        this.lastEvaluatedStreamArn = builder.lastEvaluatedStreamArn;
    }

    public List<Stream> streams() {
        return this.streams;
    }

    public String lastEvaluatedStreamArn() {
        return this.lastEvaluatedStreamArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.streams() == null ? 0 : this.streams().hashCode());
        hashCode = 31 * hashCode + (this.lastEvaluatedStreamArn() == null ? 0 : this.lastEvaluatedStreamArn().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamsResponse)) {
            return false;
        }
        ListStreamsResponse other = (ListStreamsResponse)((Object)obj);
        if (other.streams() == null ^ this.streams() == null) {
            return false;
        }
        if (other.streams() != null && !other.streams().equals(this.streams())) {
            return false;
        }
        if (other.lastEvaluatedStreamArn() == null ^ this.lastEvaluatedStreamArn() == null) {
            return false;
        }
        return other.lastEvaluatedStreamArn() == null || other.lastEvaluatedStreamArn().equals(this.lastEvaluatedStreamArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.streams() != null) {
            sb.append("Streams: ").append(this.streams()).append(",");
        }
        if (this.lastEvaluatedStreamArn() != null) {
            sb.append("LastEvaluatedStreamArn: ").append(this.lastEvaluatedStreamArn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Stream> streams;
        private String lastEvaluatedStreamArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamsResponse model) {
            this.setStreams(model.streams);
            this.setLastEvaluatedStreamArn(model.lastEvaluatedStreamArn);
        }

        public final Collection<Stream> getStreams() {
            return this.streams;
        }

        @Override
        public final Builder streams(Collection<Stream> streams) {
            this.streams = StreamListCopier.copy(streams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streams(Stream ... streams) {
            if (this.streams == null) {
                this.streams = new ArrayList<Stream>(streams.length);
            }
            for (Stream e : streams) {
                this.streams.add(e);
            }
            return this;
        }

        public final void setStreams(Collection<Stream> streams) {
            this.streams = StreamListCopier.copy(streams);
        }

        @SafeVarargs
        public final void setStreams(Stream ... streams) {
            if (this.streams == null) {
                this.streams = new ArrayList<Stream>(streams.length);
            }
            for (Stream e : streams) {
                this.streams.add(e);
            }
        }

        public final String getLastEvaluatedStreamArn() {
            return this.lastEvaluatedStreamArn;
        }

        @Override
        public final Builder lastEvaluatedStreamArn(String lastEvaluatedStreamArn) {
            this.lastEvaluatedStreamArn = lastEvaluatedStreamArn;
            return this;
        }

        public final void setLastEvaluatedStreamArn(String lastEvaluatedStreamArn) {
            this.lastEvaluatedStreamArn = lastEvaluatedStreamArn;
        }

        public ListStreamsResponse build() {
            return new ListStreamsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListStreamsResponse> {
        public Builder streams(Collection<Stream> var1);

        public Builder streams(Stream ... var1);

        public Builder lastEvaluatedStreamArn(String var1);
    }
}

