/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.Capacity;
import software.amazon.awssdk.services.dynamodb.model.SecondaryIndexesCapacityMapCopier;
import software.amazon.awssdk.services.dynamodb.transform.ConsumedCapacityMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ConsumedCapacity
implements StructuredPojo,
ToCopyableBuilder<Builder, ConsumedCapacity> {
    private final String tableName;
    private final Double capacityUnits;
    private final Capacity table;
    private final Map<String, Capacity> localSecondaryIndexes;
    private final Map<String, Capacity> globalSecondaryIndexes;

    private ConsumedCapacity(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.capacityUnits = builder.capacityUnits;
        this.table = builder.table;
        this.localSecondaryIndexes = builder.localSecondaryIndexes;
        this.globalSecondaryIndexes = builder.globalSecondaryIndexes;
    }

    public String tableName() {
        return this.tableName;
    }

    public Double capacityUnits() {
        return this.capacityUnits;
    }

    public Capacity table() {
        return this.table;
    }

    public Map<String, Capacity> localSecondaryIndexes() {
        return this.localSecondaryIndexes;
    }

    public Map<String, Capacity> globalSecondaryIndexes() {
        return this.globalSecondaryIndexes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.tableName() == null ? 0 : this.tableName().hashCode());
        hashCode = 31 * hashCode + (this.capacityUnits() == null ? 0 : this.capacityUnits().hashCode());
        hashCode = 31 * hashCode + (this.table() == null ? 0 : this.table().hashCode());
        hashCode = 31 * hashCode + (this.localSecondaryIndexes() == null ? 0 : this.localSecondaryIndexes().hashCode());
        hashCode = 31 * hashCode + (this.globalSecondaryIndexes() == null ? 0 : this.globalSecondaryIndexes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConsumedCapacity)) {
            return false;
        }
        ConsumedCapacity other = (ConsumedCapacity)obj;
        if (other.tableName() == null ^ this.tableName() == null) {
            return false;
        }
        if (other.tableName() != null && !other.tableName().equals(this.tableName())) {
            return false;
        }
        if (other.capacityUnits() == null ^ this.capacityUnits() == null) {
            return false;
        }
        if (other.capacityUnits() != null && !other.capacityUnits().equals(this.capacityUnits())) {
            return false;
        }
        if (other.table() == null ^ this.table() == null) {
            return false;
        }
        if (other.table() != null && !other.table().equals(this.table())) {
            return false;
        }
        if (other.localSecondaryIndexes() == null ^ this.localSecondaryIndexes() == null) {
            return false;
        }
        if (other.localSecondaryIndexes() != null && !other.localSecondaryIndexes().equals(this.localSecondaryIndexes())) {
            return false;
        }
        if (other.globalSecondaryIndexes() == null ^ this.globalSecondaryIndexes() == null) {
            return false;
        }
        return other.globalSecondaryIndexes() == null || other.globalSecondaryIndexes().equals(this.globalSecondaryIndexes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.tableName() != null) {
            sb.append("TableName: ").append(this.tableName()).append(",");
        }
        if (this.capacityUnits() != null) {
            sb.append("CapacityUnits: ").append(this.capacityUnits()).append(",");
        }
        if (this.table() != null) {
            sb.append("Table: ").append(this.table()).append(",");
        }
        if (this.localSecondaryIndexes() != null) {
            sb.append("LocalSecondaryIndexes: ").append(this.localSecondaryIndexes()).append(",");
        }
        if (this.globalSecondaryIndexes() != null) {
            sb.append("GlobalSecondaryIndexes: ").append(this.globalSecondaryIndexes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConsumedCapacityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String tableName;
        private Double capacityUnits;
        private Capacity table;
        private Map<String, Capacity> localSecondaryIndexes;
        private Map<String, Capacity> globalSecondaryIndexes;

        private BuilderImpl() {
        }

        private BuilderImpl(ConsumedCapacity model) {
            this.setTableName(model.tableName);
            this.setCapacityUnits(model.capacityUnits);
            this.setTable(model.table);
            this.setLocalSecondaryIndexes(model.localSecondaryIndexes);
            this.setGlobalSecondaryIndexes(model.globalSecondaryIndexes);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Double getCapacityUnits() {
            return this.capacityUnits;
        }

        @Override
        public final Builder capacityUnits(Double capacityUnits) {
            this.capacityUnits = capacityUnits;
            return this;
        }

        public final void setCapacityUnits(Double capacityUnits) {
            this.capacityUnits = capacityUnits;
        }

        public final Capacity getTable() {
            return this.table;
        }

        @Override
        public final Builder table(Capacity table) {
            this.table = table;
            return this;
        }

        public final void setTable(Capacity table) {
            this.table = table;
        }

        public final Map<String, Capacity> getLocalSecondaryIndexes() {
            return this.localSecondaryIndexes;
        }

        @Override
        public final Builder localSecondaryIndexes(Map<String, Capacity> localSecondaryIndexes) {
            this.localSecondaryIndexes = SecondaryIndexesCapacityMapCopier.copy(localSecondaryIndexes);
            return this;
        }

        public final void setLocalSecondaryIndexes(Map<String, Capacity> localSecondaryIndexes) {
            this.localSecondaryIndexes = SecondaryIndexesCapacityMapCopier.copy(localSecondaryIndexes);
        }

        public final Map<String, Capacity> getGlobalSecondaryIndexes() {
            return this.globalSecondaryIndexes;
        }

        @Override
        public final Builder globalSecondaryIndexes(Map<String, Capacity> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = SecondaryIndexesCapacityMapCopier.copy(globalSecondaryIndexes);
            return this;
        }

        public final void setGlobalSecondaryIndexes(Map<String, Capacity> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = SecondaryIndexesCapacityMapCopier.copy(globalSecondaryIndexes);
        }

        public ConsumedCapacity build() {
            return new ConsumedCapacity(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ConsumedCapacity> {
        public Builder tableName(String var1);

        public Builder capacityUnits(Double var1);

        public Builder table(Capacity var1);

        public Builder localSecondaryIndexes(Map<String, Capacity> var1);

        public Builder globalSecondaryIndexes(Map<String, Capacity> var1);
    }
}

