/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.document.spec;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.event.ProgressListener;
import software.amazon.awssdk.metrics.RequestMetricCollector;
import software.amazon.awssdk.services.dynamodb.document.KeyAttribute;
import software.amazon.awssdk.services.dynamodb.document.PrimaryKey;
import software.amazon.awssdk.services.dynamodb.document.QueryFilter;
import software.amazon.awssdk.services.dynamodb.document.RangeKeyCondition;
import software.amazon.awssdk.services.dynamodb.document.spec.AbstractCollectionSpec;
import software.amazon.awssdk.services.dynamodb.model.ConditionalOperator;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.Select;

public class QuerySpec
extends AbstractCollectionSpec<QueryRequest> {
    private KeyAttribute hashKey;
    private RangeKeyCondition rangeKeyCondition;
    private Collection<QueryFilter> queryFilters;
    private Map<String, String> nameMap;
    private Map<String, Object> valueMap;
    private Collection<KeyAttribute> exclusiveStartKey;

    public QuerySpec() {
        super((AmazonWebServiceRequest)QueryRequest.builder().build());
    }

    public KeyAttribute getHashKey() {
        return this.hashKey;
    }

    public QuerySpec withHashKey(KeyAttribute hashKey) {
        this.hashKey = hashKey;
        return this;
    }

    public QuerySpec withHashKey(String hashKeyName, Object hashKeyValue) {
        this.hashKey = new KeyAttribute(hashKeyName, hashKeyValue);
        return this;
    }

    public RangeKeyCondition getRangeKeyCondition() {
        return this.rangeKeyCondition;
    }

    public QuerySpec withRangeKeyCondition(RangeKeyCondition rangeKeyCondition) {
        this.rangeKeyCondition = rangeKeyCondition;
        return this;
    }

    public QuerySpec withKeyConditionExpression(String keyConditionExpression) {
        this.setRequest((AmazonWebServiceRequest)((QueryRequest)((Object)this.getRequest())).toBuilder().keyConditionExpression(keyConditionExpression).build());
        return this;
    }

    public String getKeyConditionExpression() {
        return ((QueryRequest)((Object)this.getRequest())).keyConditionExpression();
    }

    public QuerySpec withAttributesToGet(String ... attributes) {
        this.setRequest((AmazonWebServiceRequest)((QueryRequest)((Object)this.getRequest())).toBuilder().attributesToGet(Arrays.asList(attributes)).build());
        return this;
    }

    public List<String> getAttributesToGet() {
        return ((QueryRequest)((Object)this.getRequest())).attributesToGet();
    }

    public QuerySpec withConditionalOperator(ConditionalOperator op) {
        this.setRequest((AmazonWebServiceRequest)((QueryRequest)((Object)this.getRequest())).toBuilder().conditionalOperator(op).build());
        return this;
    }

    public String getConditionalOperator() {
        return ((QueryRequest)((Object)this.getRequest())).conditionalOperator();
    }

    public QuerySpec withConsistentRead(boolean consistentRead) {
        this.setRequest((AmazonWebServiceRequest)((QueryRequest)((Object)this.getRequest())).toBuilder().consistentRead(consistentRead).build());
        return this;
    }

    public boolean isConsistentRead() {
        return ((QueryRequest)((Object)this.getRequest())).consistentRead();
    }

    public QuerySpec withQueryFilters(QueryFilter ... queryFilters) {
        if (queryFilters == null) {
            this.queryFilters = null;
        } else {
            LinkedHashSet<String> names = new LinkedHashSet<String>();
            for (QueryFilter e : queryFilters) {
                names.add(e.getAttribute());
            }
            if (names.size() != queryFilters.length) {
                throw new IllegalArgumentException("attribute names must not duplicate in the list of query filters");
            }
            this.queryFilters = Arrays.asList(queryFilters);
        }
        return this;
    }

    public Collection<QueryFilter> getQueryFilters() {
        return this.queryFilters;
    }

    public QuerySpec withFilterExpression(String filterExpression) {
        this.setRequest((AmazonWebServiceRequest)((QueryRequest)((Object)this.getRequest())).toBuilder().filterExpression(filterExpression).build());
        return this;
    }

    public String getFilterExpression() {
        return ((QueryRequest)((Object)this.getRequest())).filterExpression();
    }

    public QuerySpec withProjectionExpression(String projectionExpression) {
        this.setRequest((AmazonWebServiceRequest)((QueryRequest)((Object)this.getRequest())).toBuilder().projectionExpression(projectionExpression).build());
        return this;
    }

    public String getProjectionExpression() {
        return ((QueryRequest)((Object)this.getRequest())).projectionExpression();
    }

    public Map<String, String> nameMap() {
        return this.nameMap;
    }

    public QuerySpec withNameMap(Map<String, String> nameMap) {
        this.nameMap = nameMap == null ? null : Collections.unmodifiableMap(new LinkedHashMap<String, String>(nameMap));
        return this;
    }

    public Map<String, Object> valueMap() {
        return this.valueMap;
    }

    public QuerySpec valueMap(Map<String, Object> valueMap) {
        this.valueMap = valueMap == null ? null : Collections.unmodifiableMap(new LinkedHashMap<String, Object>(valueMap));
        return this;
    }

    public String getReturnConsumedCapacity() {
        return ((QueryRequest)((Object)this.getRequest())).returnConsumedCapacity();
    }

    public QuerySpec withReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.setRequest((AmazonWebServiceRequest)((QueryRequest)((Object)this.getRequest())).toBuilder().returnConsumedCapacity(returnConsumedCapacity).build());
        return this;
    }

    public QuerySpec withScanIndexForward(boolean scanIndexForward) {
        this.setRequest((AmazonWebServiceRequest)((QueryRequest)((Object)this.getRequest())).toBuilder().scanIndexForward(scanIndexForward).build());
        return this;
    }

    public boolean isScanIndexForward() {
        return ((QueryRequest)((Object)this.getRequest())).scanIndexForward();
    }

    public QuerySpec withSelect(Select select) {
        this.setRequest((AmazonWebServiceRequest)((QueryRequest)((Object)this.getRequest())).toBuilder().select(select).build());
        return this;
    }

    public String select() {
        return ((QueryRequest)((Object)this.getRequest())).select();
    }

    public Collection<KeyAttribute> getExclusiveStartKey() {
        return this.exclusiveStartKey;
    }

    public QuerySpec withExclusiveStartKey(KeyAttribute ... exclusiveStartKey) {
        this.exclusiveStartKey = exclusiveStartKey == null ? null : Arrays.asList(exclusiveStartKey);
        return this;
    }

    public QuerySpec withExclusiveStartKey(PrimaryKey exclusiveStartKey) {
        this.exclusiveStartKey = exclusiveStartKey == null ? null : exclusiveStartKey.getComponents();
        return this;
    }

    public QuerySpec withExclusiveStartKey(String hashKeyName, Object hashKeyValue) {
        return this.withExclusiveStartKey(new KeyAttribute(hashKeyName, hashKeyValue));
    }

    public QuerySpec withExclusiveStartKey(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue) {
        return this.withExclusiveStartKey(new KeyAttribute(hashKeyName, hashKeyValue), new KeyAttribute(rangeKeyName, rangeKeyValue));
    }

    public QuerySpec withMaxResultSize(Integer maxResultSize) {
        this.setMaxResultSize(maxResultSize);
        return this;
    }

    public QuerySpec withMaxResultSize(int maxResultSize) {
        this.setMaxResultSize(maxResultSize);
        return this;
    }

    public QuerySpec withMaxPageSize(Integer maxPageSize) {
        this.setMaxPageSize(maxPageSize);
        return this;
    }

    public QuerySpec withMaxPageSize(int maxPageSize) {
        this.setMaxPageSize(maxPageSize);
        return this;
    }

    public QuerySpec withProgressListener(ProgressListener progressListener) {
        this.setProgressListener(progressListener);
        return this;
    }

    public QuerySpec withRequestMetricCollector(RequestMetricCollector requestMetricCollector) {
        this.setRequestMetricCollector(requestMetricCollector);
        return this;
    }
}

