/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.document.spec;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.event.ProgressListener;
import software.amazon.awssdk.metrics.RequestMetricCollector;
import software.amazon.awssdk.services.dynamodb.document.internal.InternalUtils;

class AbstractSpec<T extends AmazonWebServiceRequest> {
    private T req;

    AbstractSpec(T req) {
        this.setRequest(req);
    }

    public void setRequest(T req) {
        InternalUtils.applyUserAgent(req);
        this.req = req;
    }

    public T getRequest() {
        return this.req;
    }

    public ProgressListener getProgressListener() {
        return this.getRequest().getGeneralProgressListener();
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.getRequest().setGeneralProgressListener(progressListener);
    }

    public RequestMetricCollector getRequestMetricCollector() {
        return this.getRequest().getRequestMetricCollector();
    }

    public void setRequestMetricCollector(RequestMetricCollector requestMetricCollector) {
        this.getRequest().setRequestMetricCollector(requestMetricCollector);
    }

    public AbstractSpec<T> withProgressListener(ProgressListener progressListener) {
        this.getRequest().setGeneralProgressListener(progressListener);
        return this;
    }

    public AbstractSpec<T> withRequestMetricCollector(RequestMetricCollector requestMetricCollector) {
        this.getRequest().setRequestMetricCollector(requestMetricCollector);
        return this;
    }
}

