/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.document.internal;

import java.util.Map;
import software.amazon.awssdk.services.dynamodb.DynamoDBClient;
import software.amazon.awssdk.services.dynamodb.document.Expected;
import software.amazon.awssdk.services.dynamodb.document.Item;
import software.amazon.awssdk.services.dynamodb.document.PutItemOutcome;
import software.amazon.awssdk.services.dynamodb.document.Table;
import software.amazon.awssdk.services.dynamodb.document.api.PutItemApi;
import software.amazon.awssdk.services.dynamodb.document.internal.AbstractImpl;
import software.amazon.awssdk.services.dynamodb.document.internal.InternalUtils;
import software.amazon.awssdk.services.dynamodb.document.spec.PutItemSpec;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeValue;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.PutItemResponse;

public class PutItemImpl
extends AbstractImpl
implements PutItemApi {
    public PutItemImpl(DynamoDBClient client, Table table) {
        super(client, table);
    }

    @Override
    public PutItemOutcome putItem(Item item) {
        return this.doPutItem(new PutItemSpec().withItem(item));
    }

    @Override
    public PutItemOutcome putItem(Item item, Expected ... expected) {
        return this.doPutItem(new PutItemSpec().withItem(item).withExpected(expected));
    }

    @Override
    public PutItemOutcome putItem(Item item, String conditionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.doPutItem(new PutItemSpec().withItem(item).withConditionExpression(conditionExpression).withNameMap(nameMap).valueMap(valueMap));
    }

    @Override
    public PutItemOutcome putItem(PutItemSpec spec) {
        return this.doPutItem(spec);
    }

    private PutItemOutcome doPutItem(PutItemSpec spec) {
        String tableName = this.getTable().getTableName();
        PutItemRequest.Builder requestBuilder = ((PutItemRequest)((Object)spec.getRequest())).toBuilder().tableName(tableName);
        Item item = spec.getItem();
        Map<String, AttributeValue> attributes = InternalUtils.toAttributeValues(item);
        Map<String, ExpectedAttributeValue> expectedMap = InternalUtils.toExpectedAttributeValueMap(spec.getExpected());
        Map<String, AttributeValue> attrValMap = InternalUtils.fromSimpleMap(spec.valueMap());
        requestBuilder.item(attributes).expected(expectedMap).expressionAttributeNames(spec.nameMap()).expressionAttributeValues(attrValMap);
        PutItemResponse result = this.getClient().putItem((PutItemRequest)((Object)requestBuilder.build()));
        return new PutItemOutcome(result);
    }
}

