/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.document.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import software.amazon.awssdk.services.dynamodb.DynamoDBClient;
import software.amazon.awssdk.services.dynamodb.document.Page;
import software.amazon.awssdk.services.dynamodb.document.Table;
import software.amazon.awssdk.services.dynamodb.document.internal.InternalUtils;
import software.amazon.awssdk.services.dynamodb.document.spec.ListTablesSpec;
import software.amazon.awssdk.services.dynamodb.model.ListTablesRequest;
import software.amazon.awssdk.services.dynamodb.model.ListTablesResponse;

class ListTablesPage
extends Page<Table, ListTablesResponse> {
    private final DynamoDBClient client;
    private final ListTablesSpec spec;
    private ListTablesRequest request;
    private final int index;
    private final String lastEvaluatedKey;

    public ListTablesPage(DynamoDBClient client, ListTablesSpec spec, ListTablesRequest request, int index, ListTablesResponse result) {
        super(Collections.unmodifiableList(ListTablesPage.toTableList(client, result.tableNames())), result);
        this.client = client;
        this.spec = spec;
        this.request = request;
        this.index = index;
        Integer max = spec.maxResultSize();
        this.lastEvaluatedKey = max != null && index + result.tableNames().size() > max ? null : result.lastEvaluatedTableName();
    }

    private static List<Table> toTableList(DynamoDBClient client, List<String> tableNames) {
        if (tableNames == null) {
            return null;
        }
        ArrayList<Table> result = new ArrayList<Table>(tableNames.size());
        for (String tableName : tableNames) {
            result.add(new Table(client, tableName));
        }
        return result;
    }

    @Override
    public boolean hasNextPage() {
        if (this.lastEvaluatedKey == null) {
            return false;
        }
        Integer max = this.spec.maxResultSize();
        if (max == null) {
            return true;
        }
        return this.nextRequestLimit(max) > 0;
    }

    private int nextRequestLimit(int max) {
        int nextIndex = this.index + this.size();
        return InternalUtils.minimum(max - nextIndex, this.spec.maxPageSize());
    }

    @Override
    public Page<Table, ListTablesResponse> nextPage() {
        if (this.lastEvaluatedKey == null) {
            throw new NoSuchElementException("No more pages");
        }
        Integer max = this.spec.maxResultSize();
        if (max != null) {
            int nextLimit = this.nextRequestLimit(max);
            if (nextLimit == 0) {
                throw new NoSuchElementException("No more pages");
            }
            this.request = (ListTablesRequest)((Object)this.request.toBuilder().limit(nextLimit).build());
        }
        this.request = (ListTablesRequest)((Object)this.request.toBuilder().exclusiveStartTableName(this.lastEvaluatedKey).build());
        ListTablesResponse result = this.client.listTables(this.request);
        int nextIndex = this.index + this.size();
        return new ListTablesPage(this.client, this.spec, this.request, nextIndex, result);
    }
}

