/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.document.internal;

import software.amazon.awssdk.services.dynamodb.document.internal.InternalUtils;
import software.amazon.awssdk.services.dynamodb.model.ComparisonOperator;

public abstract class Filter<T extends Filter<T>> {
    private final String attribute;
    private ComparisonOperator op;
    private Object[] values;

    protected Filter(String attrName) {
        InternalUtils.checkInvalidAttrName(attrName);
        this.attribute = attrName;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public ComparisonOperator getComparisonOperator() {
        return this.op;
    }

    public Object[] values() {
        return this.values == null ? null : (Object[])this.values.clone();
    }

    protected T values(Object ... values) {
        this.values = (Object[])values.clone();
        return (T)this;
    }

    private T withComparisonOperator(ComparisonOperator op) {
        this.op = op;
        return (T)this;
    }

    public T eq(Object val) {
        return ((Filter)this.withComparisonOperator(ComparisonOperator.EQ)).values(val);
    }

    public T ne(Object val) {
        return ((Filter)this.withComparisonOperator(ComparisonOperator.NE)).values(val);
    }

    public T exists() {
        return this.withComparisonOperator(ComparisonOperator.NOT_NULL);
    }

    public T notExist() {
        return this.withComparisonOperator(ComparisonOperator.NULL);
    }

    public T contains(Object val) {
        return ((Filter)this.withComparisonOperator(ComparisonOperator.CONTAINS)).values(val);
    }

    public T notContains(Object val) {
        return ((Filter)this.withComparisonOperator(ComparisonOperator.NOT_CONTAINS)).values(val);
    }

    public T beginsWith(String val) {
        return ((Filter)this.withComparisonOperator(ComparisonOperator.BEGINS_WITH)).values(val);
    }

    public T in(Object ... values) {
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException("values must not be null or empty.");
        }
        return ((Filter)this.withComparisonOperator(ComparisonOperator.IN)).values(values);
    }

    public T between(Object low, Object hi) {
        return ((Filter)this.withComparisonOperator(ComparisonOperator.BETWEEN)).values(low, hi);
    }

    public T ge(Object val) {
        return ((Filter)this.withComparisonOperator(ComparisonOperator.GE)).values(val);
    }

    public T gt(Object val) {
        return ((Filter)this.withComparisonOperator(ComparisonOperator.GT)).values(val);
    }

    public T le(Object val) {
        return ((Filter)this.withComparisonOperator(ComparisonOperator.LE)).values(val);
    }

    public T lt(Object val) {
        return ((Filter)this.withComparisonOperator(ComparisonOperator.LT)).values(val);
    }
}

