/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.document;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.services.dynamodb.document.Item;
import software.amazon.awssdk.services.dynamodb.document.internal.InternalUtils;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;

public class BatchGetItemOutcome {
    private final BatchGetItemResponse result;

    public BatchGetItemOutcome(BatchGetItemResponse result) {
        if (result == null) {
            throw new IllegalArgumentException();
        }
        this.result = result;
    }

    public Map<String, List<Item>> getTableItems() {
        Map<String, List<Map<String, AttributeValue>>> res = this.result.responses();
        LinkedHashMap<String, List<Item>> map = new LinkedHashMap<String, List<Item>>(res.size());
        for (Map.Entry<String, List<Map<String, AttributeValue>>> e : res.entrySet()) {
            String tableName = e.getKey();
            List<Map<String, AttributeValue>> items = e.getValue();
            map.put(tableName, InternalUtils.toItemList(items));
        }
        return map;
    }

    public Map<String, KeysAndAttributes> getUnprocessedKeys() {
        return this.result.unprocessedKeys();
    }

    public BatchGetItemResponse batchGetItemResponse() {
        return this.result;
    }

    public String toString() {
        return String.valueOf((Object)this.result);
    }
}

