/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers;

import java.text.ParseException;
import java.util.LinkedHashSet;
import java.util.List;
import software.amazon.awssdk.services.dynamodb.datamodeling.ArgumentUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMappingException;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.LUnmarshaller;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class ObjectSetUnmarshaller
extends LUnmarshaller {
    private static final ObjectSetUnmarshaller INSTANCE = new ObjectSetUnmarshaller();
    private final ArgumentUnmarshaller memberUnmarshaller;

    private ObjectSetUnmarshaller() {
        this.memberUnmarshaller = null;
    }

    public ObjectSetUnmarshaller(ArgumentUnmarshaller memberUnmarshaller) {
        if (memberUnmarshaller == null) {
            throw new NullPointerException("memberUnmarshaller");
        }
        this.memberUnmarshaller = memberUnmarshaller;
    }

    public static ObjectSetUnmarshaller instance() {
        return INSTANCE;
    }

    @Override
    public Object unmarshall(AttributeValue value) throws ParseException {
        List<AttributeValue> values = value.l();
        int size = Math.max(values.size() * 2, 11);
        LinkedHashSet<Object> objects = new LinkedHashSet<Object>(size);
        for (AttributeValue v : values) {
            this.memberUnmarshaller.typeCheck(v, null);
            Object o = this.memberUnmarshaller.unmarshall(v);
            if (objects.add(o)) continue;
            throw new DynamoDbMappingException("Duplicate value (" + o + ") found in " + values);
        }
        return objects;
    }
}

