/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.services.dynamodb.datamodeling.ArgumentUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.LUnmarshaller;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class ListUnmarshaller
extends LUnmarshaller {
    private static final ListUnmarshaller INSTANCE = new ListUnmarshaller();
    private final ArgumentUnmarshaller memberUnmarshaller;

    private ListUnmarshaller() {
        this.memberUnmarshaller = null;
    }

    public ListUnmarshaller(ArgumentUnmarshaller memberUnmarshaller) {
        if (memberUnmarshaller == null) {
            throw new NullPointerException("memberUnmarshaller");
        }
        this.memberUnmarshaller = memberUnmarshaller;
    }

    public static ListUnmarshaller instance() {
        return INSTANCE;
    }

    @Override
    public Object unmarshall(AttributeValue value) throws ParseException {
        List<AttributeValue> values = value.l();
        ArrayList<Object> objects = new ArrayList<Object>(values.size());
        for (AttributeValue v : values) {
            this.memberUnmarshaller.typeCheck(v, null);
            objects.add(this.memberUnmarshaller.unmarshall(v));
        }
        return objects;
    }
}

