/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers;

import java.nio.ByteBuffer;
import java.util.HashSet;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.BsUnmarshaller;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class ByteArraySetUnmarshaller
extends BsUnmarshaller {
    private static final ByteArraySetUnmarshaller INSTANCE = new ByteArraySetUnmarshaller();

    private ByteArraySetUnmarshaller() {
    }

    public static ByteArraySetUnmarshaller instance() {
        return INSTANCE;
    }

    @Override
    public Object unmarshall(AttributeValue value) {
        HashSet<byte[]> result = new HashSet<byte[]>();
        for (ByteBuffer buffer : value.bs()) {
            if (buffer.hasArray()) {
                result.add(buffer.array());
                continue;
            }
            byte[] array = new byte[buffer.remaining()];
            buffer.get(array);
            result.add(array);
        }
        return result;
    }
}

