/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling.marshallers;

import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import software.amazon.awssdk.services.dynamodb.datamodeling.ArgumentMarshaller;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.util.DateUtils;

public class DateSetToStringSetMarshaller
implements ArgumentMarshaller.StringSetAttributeMarshaller {
    private static final DateSetToStringSetMarshaller INSTANCE = new DateSetToStringSetMarshaller();

    private DateSetToStringSetMarshaller() {
    }

    public static DateSetToStringSetMarshaller instance() {
        return INSTANCE;
    }

    @Override
    public AttributeValue marshall(Object obj) {
        Set dates = (Set)obj;
        ArrayList<String> timestamps = new ArrayList<String>(dates.size());
        for (Date date : dates) {
            timestamps.add(DateUtils.formatIso8601Date((Date)date));
        }
        return (AttributeValue)AttributeValue.builder().ss(timestamps).build();
    }
}

