/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling.marshallers;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Set;
import software.amazon.awssdk.services.dynamodb.datamodeling.ArgumentMarshaller;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class ByteArraySetToBinarySetMarshaller
implements ArgumentMarshaller.BinarySetAttributeMarshaller {
    private static final ByteArraySetToBinarySetMarshaller INSTANCE = new ByteArraySetToBinarySetMarshaller();

    private ByteArraySetToBinarySetMarshaller() {
    }

    public static ByteArraySetToBinarySetMarshaller instance() {
        return INSTANCE;
    }

    @Override
    public AttributeValue marshall(Object obj) {
        Set buffers = (Set)obj;
        ArrayList<ByteBuffer> attributes = new ArrayList<ByteBuffer>(buffers.size());
        for (byte[] b : buffers) {
            attributes.add(ByteBuffer.wrap(b));
        }
        return (AttributeValue)AttributeValue.builder().bs(attributes).build();
    }
}

