/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDb;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbAutoGenerateStrategy;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbAutoGenerated;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbAutoGenerator;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbTypeConverter;
import software.amazon.awssdk.services.dynamodb.datamodeling.StandardTypeConverters;

@DynamoDb
@DynamoDbAutoGenerated(generator=Generator.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD})
public @interface DynamoDbAutoGeneratedDefault {
    public String value();

    public static final class Generator<T>
    extends DynamoDbAutoGenerator.AbstractGenerator<T> {
        private final DynamoDbTypeConverter<T, String> converter;
        private final String defaultValue;

        public Generator(Class<T> targetType, DynamoDbAutoGeneratedDefault annotation) {
            super(DynamoDbAutoGenerateStrategy.CREATE);
            this.converter = StandardTypeConverters.factory().getConverter(targetType, String.class);
            this.defaultValue = annotation.value();
        }

        @Override
        public final T generate(T currentValue) {
            return this.converter.convert(this.defaultValue);
        }
    }
}

