/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.mapper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.IndexMetadata;
import software.amazon.awssdk.enhanced.dynamodb.KeyAttributeMetadata;

@SdkInternalApi
public class StaticIndexMetadata
implements IndexMetadata {
    private final String name;
    private final List<KeyAttributeMetadata> partitionKeys;
    private final List<KeyAttributeMetadata> sortKeys;

    private StaticIndexMetadata(Builder b) {
        this.name = b.name;
        this.partitionKeys = Collections.unmodifiableList(b.partitionKeys.stream().sorted(Comparator.comparingInt(key -> key.order().getIndex())).collect(Collectors.toList()));
        this.sortKeys = Collections.unmodifiableList(b.sortKeys.stream().sorted(Comparator.comparingInt(key -> key.order().getIndex())).collect(Collectors.toList()));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderFrom(IndexMetadata index) {
        if (index == null) {
            return StaticIndexMetadata.builder();
        }
        return StaticIndexMetadata.builder().name(index.name()).partitionKeys(index.partitionKeys()).sortKeys(index.sortKeys());
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public List<KeyAttributeMetadata> partitionKeys() {
        return this.partitionKeys;
    }

    @Override
    public List<KeyAttributeMetadata> sortKeys() {
        return this.sortKeys;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StaticIndexMetadata that = (StaticIndexMetadata)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (!this.partitionKeys.equals(that.partitionKeys)) {
            return false;
        }
        return this.sortKeys.equals(that.sortKeys);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = StaticIndexMetadata.listHashCode(this.partitionKeys, result);
        result = StaticIndexMetadata.listHashCode(this.sortKeys, result);
        return result;
    }

    private static int listHashCode(List<KeyAttributeMetadata> list, int hash) {
        int result = hash;
        for (KeyAttributeMetadata key : list) {
            result = 31 * result + key.hashCode();
        }
        return result;
    }

    @NotThreadSafe
    public static class Builder {
        private String name;
        private List<KeyAttributeMetadata> partitionKeys = new ArrayList<KeyAttributeMetadata>();
        private List<KeyAttributeMetadata> sortKeys = new ArrayList<KeyAttributeMetadata>();

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder partitionKeys(List<KeyAttributeMetadata> partitionKeys) {
            this.partitionKeys = new ArrayList<KeyAttributeMetadata>(partitionKeys);
            return this;
        }

        public Builder sortKeys(List<KeyAttributeMetadata> sortKeys) {
            this.sortKeys = new ArrayList<KeyAttributeMetadata>(sortKeys);
            return this;
        }

        public Builder addPartitionKey(KeyAttributeMetadata partitionKey) {
            this.partitionKeys.add(partitionKey);
            return this;
        }

        public Builder addSortKey(KeyAttributeMetadata sortKey) {
            this.sortKeys.add(sortKey);
            return this;
        }

        public List<KeyAttributeMetadata> getPartitionKeys() {
            return new ArrayList<KeyAttributeMetadata>(this.partitionKeys);
        }

        public List<KeyAttributeMetadata> getSortKeys() {
            return new ArrayList<KeyAttributeMetadata>(this.sortKeys);
        }

        public Builder partitionKey(KeyAttributeMetadata partitionKey) {
            this.partitionKeys = new ArrayList<KeyAttributeMetadata>();
            if (partitionKey != null) {
                this.partitionKeys.add(partitionKey);
            }
            return this;
        }

        public Builder sortKey(KeyAttributeMetadata sortKey) {
            this.sortKeys = new ArrayList<KeyAttributeMetadata>();
            if (sortKey != null) {
                this.sortKeys.add(sortKey);
            }
            return this;
        }

        public StaticIndexMetadata build() {
            return new StaticIndexMetadata(this);
        }
    }
}

