/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.mapper;

import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.enhanced.dynamodb.ExecutionContext;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.mapper.BeanTableSchema;
import software.amazon.awssdk.enhanced.dynamodb.mapper.ImmutableTableSchema;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbBean;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbImmutable;

@SdkProtectedApi
public class TableSchemaFactory {
    private TableSchemaFactory() {
    }

    public static <T> TableSchema<T> fromClass(Class<T> annotatedClass, ExecutionContext context) {
        if (annotatedClass.getAnnotation(DynamoDbImmutable.class) != null) {
            return ImmutableTableSchema.create(annotatedClass, context);
        }
        if (annotatedClass.getAnnotation(DynamoDbBean.class) != null) {
            return BeanTableSchema.create(annotatedClass, context);
        }
        throw new IllegalArgumentException("Class does not appear to be a valid DynamoDb annotated class. [class = \"" + annotatedClass + "\"]");
    }
}

