/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.string;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.PrimitiveConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.StringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.StringConverterProvider;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.AtomicBooleanStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.AtomicIntegerStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.AtomicLongStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.BigDecimalStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.BigIntegerStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.BooleanStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.ByteArrayStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.ByteStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.CharSequenceStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.CharacterArrayStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.CharacterStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.DoubleStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.DurationStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.FloatStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.InstantStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.IntegerStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.LocalDateStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.LocalDateTimeStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.LocalTimeStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.LocaleStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.LongStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.MonthDayStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.OffsetDateTimeStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.OffsetTimeStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.OptionalDoubleStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.OptionalIntStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.OptionalLongStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.PeriodStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.ShortStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.StringBufferStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.StringBuilderStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.StringStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.UriStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.UrlStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.UuidStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.YearMonthStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.YearStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.ZoneIdStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.ZoneOffsetStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.ZonedDateTimeStringConverter;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
@ThreadSafe
@Immutable
public class DefaultStringConverterProvider
implements StringConverterProvider {
    private final ConcurrentHashMap<EnhancedType<?>, StringConverter<?>> converterCache = new ConcurrentHashMap();

    private DefaultStringConverterProvider(Builder builder) {
        for (int i = builder.converters.size() - 1; i >= 0; --i) {
            StringConverter converter = (StringConverter)builder.converters.get(i);
            this.converterCache.put(converter.type(), converter);
            if (!(converter instanceof PrimitiveConverter)) continue;
            PrimitiveConverter primitiveConverter = (PrimitiveConverter)((Object)converter);
            this.converterCache.put(primitiveConverter.primitiveType(), converter);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DefaultStringConverterProvider create() {
        return DefaultStringConverterProvider.builder().addConverter(ByteArrayStringConverter.create()).addConverter(CharacterArrayStringConverter.create()).addConverter(BooleanStringConverter.create()).addConverter(ShortStringConverter.create()).addConverter(IntegerStringConverter.create()).addConverter(LongStringConverter.create()).addConverter(FloatStringConverter.create()).addConverter(DoubleStringConverter.create()).addConverter(CharacterStringConverter.create()).addConverter(ByteStringConverter.create()).addConverter(StringStringConverter.create()).addConverter(CharSequenceStringConverter.create()).addConverter(StringBufferStringConverter.create()).addConverter(StringBuilderStringConverter.create()).addConverter(BigIntegerStringConverter.create()).addConverter(BigDecimalStringConverter.create()).addConverter(AtomicLongStringConverter.create()).addConverter(AtomicIntegerStringConverter.create()).addConverter(AtomicBooleanStringConverter.create()).addConverter(OptionalIntStringConverter.create()).addConverter(OptionalLongStringConverter.create()).addConverter(OptionalDoubleStringConverter.create()).addConverter(InstantStringConverter.create()).addConverter(DurationStringConverter.create()).addConverter(LocalDateStringConverter.create()).addConverter(LocalTimeStringConverter.create()).addConverter(LocalDateTimeStringConverter.create()).addConverter(LocaleStringConverter.create()).addConverter(OffsetTimeStringConverter.create()).addConverter(OffsetDateTimeStringConverter.create()).addConverter(ZonedDateTimeStringConverter.create()).addConverter(YearStringConverter.create()).addConverter(YearMonthStringConverter.create()).addConverter(MonthDayStringConverter.create()).addConverter(PeriodStringConverter.create()).addConverter(ZoneOffsetStringConverter.create()).addConverter(ZoneIdStringConverter.create()).addConverter(UuidStringConverter.create()).addConverter(UrlStringConverter.create()).addConverter(UriStringConverter.create()).build();
    }

    public <T> StringConverter converterFor(EnhancedType<T> enhancedType) {
        StringConverter<?> converter = this.converterCache.get(enhancedType);
        if (converter == null) {
            throw new IllegalArgumentException("No string converter exists for " + enhancedType.rawClass());
        }
        return converter;
    }

    @NotThreadSafe
    public static class Builder {
        private List<StringConverter<?>> converters = new ArrayList();

        private Builder() {
        }

        public Builder addConverters(Collection<? extends StringConverter<?>> converters) {
            Validate.paramNotNull(converters, (String)"converters");
            Validate.noNullElements(converters, (String)"Converters must not contain null members.", (Object[])new Object[0]);
            this.converters.addAll(converters);
            return this;
        }

        public Builder addConverter(StringConverter<?> converter) {
            Validate.paramNotNull(converter, (String)"converter");
            this.converters.add(converter);
            return this;
        }

        public Builder clearConverters() {
            this.converters.clear();
            return this;
        }

        public DefaultStringConverterProvider build() {
            return new DefaultStringConverterProvider(this);
        }
    }
}

