/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.string;

import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.PrimitiveConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.StringConverter;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
@ThreadSafe
@Immutable
public class CharacterStringConverter
implements StringConverter<Character>,
PrimitiveConverter<Character> {
    private CharacterStringConverter() {
    }

    public static CharacterStringConverter create() {
        return new CharacterStringConverter();
    }

    @Override
    public EnhancedType<Character> type() {
        return EnhancedType.of(Character.class);
    }

    @Override
    public EnhancedType<Character> primitiveType() {
        return EnhancedType.of(Character.TYPE);
    }

    @Override
    public Character fromString(String string) {
        Validate.isTrue((string.length() == 1 ? 1 : 0) != 0, (String)"Character string was not of length 1: %s", (Object[])new Object[]{string});
        return Character.valueOf(string.charAt(0));
    }
}

