/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.operations;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.OperationContext;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;

@SdkInternalApi
public class DefaultOperationContext
implements OperationContext {
    private final String tableName;
    private final String indexName;

    private DefaultOperationContext(String tableName, String indexName) {
        this.tableName = tableName;
        this.indexName = indexName;
    }

    public static DefaultOperationContext create(String tableName, String indexName) {
        return new DefaultOperationContext(tableName, indexName);
    }

    public static DefaultOperationContext create(String tableName) {
        return new DefaultOperationContext(tableName, TableMetadata.primaryIndexName());
    }

    @Override
    public String tableName() {
        return this.tableName;
    }

    @Override
    public String indexName() {
        return this.indexName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultOperationContext that = (DefaultOperationContext)o;
        if (this.tableName != null ? !this.tableName.equals(that.tableName) : that.tableName != null) {
            return false;
        }
        return this.indexName != null ? this.indexName.equals(that.indexName) : that.indexName == null;
    }

    public int hashCode() {
        int result = this.tableName != null ? this.tableName.hashCode() : 0;
        result = 31 * result + (this.indexName != null ? this.indexName.hashCode() : 0);
        return result;
    }
}

