/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.document.DocumentTableSchema;
import software.amazon.awssdk.enhanced.dynamodb.mapper.BeanTableSchema;
import software.amazon.awssdk.enhanced.dynamodb.mapper.ImmutableTableSchema;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticImmutableTableSchema;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticTableSchema;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbBean;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbImmutable;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkPublicApi
@ThreadSafe
public interface TableSchema<T> {
    public static <T> StaticTableSchema.Builder<T> builder(Class<T> itemClass) {
        return StaticTableSchema.builder(itemClass);
    }

    public static <T> StaticTableSchema.Builder<T> builder(EnhancedType<T> itemType) {
        return StaticTableSchema.builder(itemType);
    }

    public static <T, B> StaticImmutableTableSchema.Builder<T, B> builder(Class<T> immutableItemClass, Class<B> immutableBuilderClass) {
        return StaticImmutableTableSchema.builder(immutableItemClass, immutableBuilderClass);
    }

    public static <T, B> StaticImmutableTableSchema.Builder<T, B> builder(EnhancedType<T> immutableItemType, EnhancedType<B> immutableBuilderType) {
        return StaticImmutableTableSchema.builder(immutableItemType, immutableBuilderType);
    }

    public static <T> BeanTableSchema<T> fromBean(Class<T> beanClass) {
        return BeanTableSchema.create(beanClass);
    }

    public static DocumentTableSchema.Builder documentSchemaBuilder() {
        return DocumentTableSchema.builder();
    }

    public static <T> ImmutableTableSchema<T> fromImmutableClass(Class<T> immutableClass) {
        return ImmutableTableSchema.create(immutableClass);
    }

    public static <T> TableSchema<T> fromClass(Class<T> annotatedClass) {
        if (annotatedClass.getAnnotation(DynamoDbImmutable.class) != null) {
            return TableSchema.fromImmutableClass(annotatedClass);
        }
        if (annotatedClass.getAnnotation(DynamoDbBean.class) != null) {
            return TableSchema.fromBean(annotatedClass);
        }
        throw new IllegalArgumentException("Class does not appear to be a valid DynamoDb annotated class. [class = \"" + annotatedClass + "\"]");
    }

    public T mapToItem(Map<String, AttributeValue> var1);

    default public T mapToItem(Map<String, AttributeValue> attributeMap, boolean preserveEmptyObject) {
        if (preserveEmptyObject) {
            throw new UnsupportedOperationException("preserveEmptyObject is not supported. You can set preserveEmptyObject to false to continue to call this operation. If you wish to enable preserveEmptyObject, please reach out to the maintainers of the implementation class for assistance.");
        }
        return this.mapToItem(attributeMap);
    }

    public Map<String, AttributeValue> itemToMap(T var1, boolean var2);

    public Map<String, AttributeValue> itemToMap(T var1, Collection<String> var2);

    public AttributeValue attributeValue(T var1, String var2);

    public TableMetadata tableMetadata();

    public EnhancedType<T> itemType();

    public List<String> attributeNames();

    public boolean isAbstract();

    default public AttributeConverter<T> converterForAttribute(Object key) {
        throw new UnsupportedOperationException();
    }
}

