/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.util.OptionalDouble;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.AttributeValues;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.ConverterUtils;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.OptionalDoubleStringConverter;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class OptionalDoubleAttributeConverter
implements AttributeConverter<OptionalDouble> {
    private static final Visitor VISITOR = new Visitor();
    private static final OptionalDoubleStringConverter STRING_CONVERTER = OptionalDoubleStringConverter.create();

    private OptionalDoubleAttributeConverter() {
    }

    public static OptionalDoubleAttributeConverter create() {
        return new OptionalDoubleAttributeConverter();
    }

    @Override
    public EnhancedType<OptionalDouble> type() {
        return EnhancedType.of(OptionalDouble.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.N;
    }

    @Override
    public AttributeValue transformFrom(OptionalDouble input) {
        if (input.isPresent()) {
            ConverterUtils.validateDouble(input.getAsDouble());
            return (AttributeValue)AttributeValue.builder().n(STRING_CONVERTER.toString(input)).build();
        }
        return AttributeValues.nullAttributeValue();
    }

    @Override
    public OptionalDouble transformTo(AttributeValue input) {
        OptionalDouble result = input.n() != null ? EnhancedAttributeValue.fromNumber(input.n()).convert(VISITOR) : EnhancedAttributeValue.fromAttributeValue(input).convert(VISITOR);
        result.ifPresent(ConverterUtils::validateDouble);
        return result;
    }

    private static final class Visitor
    extends TypeConvertingVisitor<OptionalDouble> {
        private Visitor() {
            super(OptionalDouble.class, OptionalDoubleAttributeConverter.class);
        }

        @Override
        public OptionalDouble convertNull() {
            return OptionalDouble.empty();
        }

        @Override
        public OptionalDouble convertString(String value) {
            return STRING_CONVERTER.fromString(value);
        }

        @Override
        public OptionalDouble convertNumber(String value) {
            return STRING_CONVERTER.fromString(value);
        }
    }
}

