/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.client;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbAsyncTable;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClientExtension;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.enhanced.dynamodb.internal.client.DefaultDynamoDbAsyncIndex;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.CreateTableOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.DeleteItemOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.DeleteTableOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.GetItemOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.PutItemOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.QueryOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.ScanOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.UpdateItemOperation;
import software.amazon.awssdk.enhanced.dynamodb.model.CreateTableEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.DeleteItemEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.GetItemEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.PagePublisher;
import software.amazon.awssdk.enhanced.dynamodb.model.PutItemEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryConditional;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.ScanEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.UpdateItemEnhancedRequest;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;

@SdkInternalApi
public final class DefaultDynamoDbAsyncTable<T>
implements DynamoDbAsyncTable<T> {
    private final DynamoDbAsyncClient dynamoDbClient;
    private final DynamoDbEnhancedClientExtension extension;
    private final TableSchema<T> tableSchema;
    private final String tableName;

    DefaultDynamoDbAsyncTable(DynamoDbAsyncClient dynamoDbClient, DynamoDbEnhancedClientExtension extension, TableSchema<T> tableSchema, String tableName) {
        this.dynamoDbClient = dynamoDbClient;
        this.extension = extension;
        this.tableSchema = tableSchema;
        this.tableName = tableName;
    }

    @Override
    public DynamoDbEnhancedClientExtension mapperExtension() {
        return this.extension;
    }

    @Override
    public TableSchema<T> tableSchema() {
        return this.tableSchema;
    }

    public DynamoDbAsyncClient dynamoDbClient() {
        return this.dynamoDbClient;
    }

    @Override
    public String tableName() {
        return this.tableName;
    }

    @Override
    public DefaultDynamoDbAsyncIndex<T> index(String indexName) {
        this.tableSchema.tableMetadata().indexPartitionKey(indexName);
        return new DefaultDynamoDbAsyncIndex<T>(this.dynamoDbClient, this.extension, this.tableSchema, this.tableName, indexName);
    }

    @Override
    public CompletableFuture<Void> createTable(CreateTableEnhancedRequest request) {
        CreateTableOperation operation = CreateTableOperation.create(request);
        return operation.executeOnPrimaryIndexAsync(this.tableSchema, this.tableName, this.extension, this.dynamoDbClient);
    }

    @Override
    public CompletableFuture<Void> createTable(Consumer<CreateTableEnhancedRequest.Builder> requestConsumer) {
        CreateTableEnhancedRequest.Builder builder = CreateTableEnhancedRequest.builder();
        requestConsumer.accept(builder);
        return this.createTable(builder.build());
    }

    @Override
    public CompletableFuture<Void> createTable() {
        return this.createTable(CreateTableEnhancedRequest.builder().build());
    }

    @Override
    public CompletableFuture<T> deleteItem(DeleteItemEnhancedRequest request) {
        DeleteItemOperation operation = DeleteItemOperation.create(request);
        return operation.executeOnPrimaryIndexAsync(this.tableSchema, this.tableName, this.extension, this.dynamoDbClient);
    }

    @Override
    public CompletableFuture<T> deleteItem(Consumer<DeleteItemEnhancedRequest.Builder> requestConsumer) {
        DeleteItemEnhancedRequest.Builder builder = DeleteItemEnhancedRequest.builder();
        requestConsumer.accept(builder);
        return this.deleteItem((T)builder.build());
    }

    @Override
    public CompletableFuture<T> deleteItem(Key key) {
        return this.deleteItem((T)((Consumer<DeleteItemEnhancedRequest.Builder>)r -> r.key(key)));
    }

    @Override
    public CompletableFuture<T> deleteItem(T keyItem) {
        return this.deleteItem((T)this.keyFrom(keyItem));
    }

    @Override
    public CompletableFuture<T> getItem(GetItemEnhancedRequest request) {
        GetItemOperation operation = GetItemOperation.create(request);
        return operation.executeOnPrimaryIndexAsync(this.tableSchema, this.tableName, this.extension, this.dynamoDbClient);
    }

    @Override
    public CompletableFuture<T> getItem(Consumer<GetItemEnhancedRequest.Builder> requestConsumer) {
        GetItemEnhancedRequest.Builder builder = GetItemEnhancedRequest.builder();
        requestConsumer.accept(builder);
        return this.getItem((T)builder.build());
    }

    @Override
    public CompletableFuture<T> getItem(Key key) {
        return this.getItem((T)((Consumer<GetItemEnhancedRequest.Builder>)r -> r.key(key)));
    }

    @Override
    public CompletableFuture<T> getItem(T keyItem) {
        return this.getItem((T)this.keyFrom(keyItem));
    }

    @Override
    public PagePublisher<T> query(QueryEnhancedRequest request) {
        QueryOperation operation = QueryOperation.create(request);
        return operation.executeOnPrimaryIndexAsync(this.tableSchema, this.tableName, this.extension, this.dynamoDbClient);
    }

    @Override
    public PagePublisher<T> query(Consumer<QueryEnhancedRequest.Builder> requestConsumer) {
        QueryEnhancedRequest.Builder builder = QueryEnhancedRequest.builder();
        requestConsumer.accept(builder);
        return this.query(builder.build());
    }

    @Override
    public PagePublisher<T> query(QueryConditional queryConditional) {
        return this.query((QueryEnhancedRequest.Builder r) -> r.queryConditional(queryConditional));
    }

    @Override
    public CompletableFuture<Void> putItem(PutItemEnhancedRequest<T> request) {
        PutItemOperation<T> operation = PutItemOperation.create(request);
        return operation.executeOnPrimaryIndexAsync(this.tableSchema, this.tableName, this.extension, this.dynamoDbClient);
    }

    @Override
    public CompletableFuture<Void> putItem(Consumer<PutItemEnhancedRequest.Builder<T>> requestConsumer) {
        PutItemEnhancedRequest.Builder<T> builder = PutItemEnhancedRequest.builder(this.tableSchema.itemType().rawClass());
        requestConsumer.accept(builder);
        return this.putItem((T)builder.build());
    }

    @Override
    public CompletableFuture<Void> putItem(T item) {
        return this.putItem((T)((Consumer<PutItemEnhancedRequest.Builder>)r -> r.item(item)));
    }

    @Override
    public PagePublisher<T> scan(ScanEnhancedRequest request) {
        ScanOperation operation = ScanOperation.create(request);
        return operation.executeOnPrimaryIndexAsync(this.tableSchema, this.tableName, this.extension, this.dynamoDbClient);
    }

    @Override
    public PagePublisher<T> scan(Consumer<ScanEnhancedRequest.Builder> requestConsumer) {
        ScanEnhancedRequest.Builder builder = ScanEnhancedRequest.builder();
        requestConsumer.accept(builder);
        return this.scan(builder.build());
    }

    @Override
    public PagePublisher<T> scan() {
        return this.scan(ScanEnhancedRequest.builder().build());
    }

    @Override
    public CompletableFuture<T> updateItem(UpdateItemEnhancedRequest<T> request) {
        UpdateItemOperation<T> operation = UpdateItemOperation.create(request);
        return operation.executeOnPrimaryIndexAsync(this.tableSchema, this.tableName, this.extension, this.dynamoDbClient);
    }

    @Override
    public CompletableFuture<T> updateItem(Consumer<UpdateItemEnhancedRequest.Builder<T>> requestConsumer) {
        UpdateItemEnhancedRequest.Builder<T> builder = UpdateItemEnhancedRequest.builder(this.tableSchema.itemType().rawClass());
        requestConsumer.accept(builder);
        return this.updateItem((T)builder.build());
    }

    @Override
    public CompletableFuture<T> updateItem(T item) {
        return this.updateItem((T)((Consumer<UpdateItemEnhancedRequest.Builder>)r -> r.item(item)));
    }

    @Override
    public Key keyFrom(T item) {
        return EnhancedClientUtils.createKeyFromItem(item, this.tableSchema, TableMetadata.primaryIndexName());
    }

    @Override
    public CompletableFuture<Void> deleteTable() {
        DeleteTableOperation operation = DeleteTableOperation.create();
        return operation.executeOnPrimaryIndexAsync(this.tableSchema, this.tableName, this.extension, this.dynamoDbClient);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultDynamoDbAsyncTable that = (DefaultDynamoDbAsyncTable)o;
        if (this.dynamoDbClient != null ? !this.dynamoDbClient.equals(that.dynamoDbClient) : that.dynamoDbClient != null) {
            return false;
        }
        if (this.extension != null ? !this.extension.equals(that.extension) : that.extension != null) {
            return false;
        }
        if (this.tableSchema != null ? !this.tableSchema.equals(that.tableSchema) : that.tableSchema != null) {
            return false;
        }
        return this.tableName != null ? this.tableName.equals(that.tableName) : that.tableName == null;
    }

    public int hashCode() {
        int result = this.dynamoDbClient != null ? this.dynamoDbClient.hashCode() : 0;
        result = 31 * result + (this.extension != null ? this.extension.hashCode() : 0);
        result = 31 * result + (this.tableSchema != null ? this.tableSchema.hashCode() : 0);
        result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
        return result;
    }
}

