/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class SdkBytesAttributeConverter
implements AttributeConverter<SdkBytes> {
    private static final Visitor VISITOR = new Visitor();

    private SdkBytesAttributeConverter() {
    }

    @Override
    public EnhancedType<SdkBytes> type() {
        return EnhancedType.of(SdkBytes.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.B;
    }

    public static SdkBytesAttributeConverter create() {
        return new SdkBytesAttributeConverter();
    }

    @Override
    public AttributeValue transformFrom(SdkBytes input) {
        return (AttributeValue)AttributeValue.builder().b(input).build();
    }

    @Override
    public SdkBytes transformTo(AttributeValue input) {
        return EnhancedAttributeValue.fromBytes(input.b()).convert(VISITOR);
    }

    private static final class Visitor
    extends TypeConvertingVisitor<SdkBytes> {
        private Visitor() {
            super(SdkBytes.class, SdkBytesAttributeConverter.class);
        }

        @Override
        public SdkBytes convertBytes(SdkBytes value) {
            return value;
        }
    }
}

