/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.mapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverterProvider;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.ResolvedImmutableAttribute;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.StaticAttributeType;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticAttributeTag;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
public final class ImmutableAttribute<T, B, R> {
    private final String name;
    private final Function<T, R> getter;
    private final BiConsumer<B, R> setter;
    private final Collection<StaticAttributeTag> tags;
    private final EnhancedType<R> type;
    private final AttributeConverter<R> attributeConverter;

    private ImmutableAttribute(Builder<T, B, R> builder) {
        this.name = (String)Validate.paramNotNull((Object)((Builder)builder).name, (String)"name");
        this.getter = (Function)Validate.paramNotNull((Object)((Builder)builder).getter, (String)"getter");
        this.setter = (BiConsumer)Validate.paramNotNull((Object)((Builder)builder).setter, (String)"setter");
        this.tags = ((Builder)builder).tags == null ? Collections.emptyList() : Collections.unmodifiableCollection(((Builder)builder).tags);
        this.type = (EnhancedType)Validate.paramNotNull((Object)((Builder)builder).type, (String)"type");
        this.attributeConverter = ((Builder)builder).attributeConverter;
    }

    public static <T, B, R> Builder<T, B, R> builder(Class<T> itemClass, Class<B> builderClass, EnhancedType<R> attributeType) {
        return new Builder(attributeType);
    }

    public static <T, B, R> Builder<T, B, R> builder(Class<T> itemClass, Class<B> builderClass, Class<R> attributeClass) {
        return new Builder(EnhancedType.of(attributeClass));
    }

    public String name() {
        return this.name;
    }

    public Function<T, R> getter() {
        return this.getter;
    }

    public BiConsumer<B, R> setter() {
        return this.setter;
    }

    public Collection<StaticAttributeTag> tags() {
        return this.tags;
    }

    public EnhancedType<R> type() {
        return this.type;
    }

    public AttributeConverter<R> attributeConverter() {
        return this.attributeConverter;
    }

    public Builder<T, B, R> toBuilder() {
        return new Builder(this.type).name(this.name).getter(this.getter).setter(this.setter).tags(this.tags).attributeConverter(this.attributeConverter);
    }

    ResolvedImmutableAttribute<T, B> resolve(AttributeConverterProvider attributeConverterProvider) {
        return ResolvedImmutableAttribute.create(this, StaticAttributeType.create(this.converterFrom(attributeConverterProvider)));
    }

    private AttributeConverter<R> converterFrom(AttributeConverterProvider attributeConverterProvider) {
        return this.attributeConverter != null ? this.attributeConverter : attributeConverterProvider.converterFor(this.type);
    }

    public static final class Builder<T, B, R> {
        private final EnhancedType<R> type;
        private String name;
        private Function<T, R> getter;
        private BiConsumer<B, R> setter;
        private List<StaticAttributeTag> tags;
        private AttributeConverter<R> attributeConverter;

        private Builder(EnhancedType<R> type) {
            this.type = type;
        }

        public Builder<T, B, R> name(String name) {
            this.name = name;
            return this;
        }

        public Builder<T, B, R> getter(Function<T, R> getter) {
            this.getter = getter;
            return this;
        }

        public Builder<T, B, R> setter(BiConsumer<B, R> setter) {
            this.setter = setter;
            return this;
        }

        public Builder<T, B, R> tags(Collection<StaticAttributeTag> tags) {
            this.tags = new ArrayList<StaticAttributeTag>(tags);
            return this;
        }

        public Builder<T, B, R> tags(StaticAttributeTag ... tags) {
            this.tags = Arrays.asList(tags);
            return this;
        }

        public Builder<T, B, R> addTag(StaticAttributeTag tag) {
            if (this.tags == null) {
                this.tags = new ArrayList<StaticAttributeTag>();
            }
            this.tags.add(tag);
            return this;
        }

        public Builder<T, B, R> attributeConverter(AttributeConverter<R> attributeConverter) {
            this.attributeConverter = attributeConverter;
            return this;
        }

        public ImmutableAttribute<T, B, R> build() {
            return new ImmutableAttribute(this);
        }
    }
}

