/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.model;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.MappedTableResource;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.DefaultOperationContext;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.GetItemOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.TransactableReadOperation;
import software.amazon.awssdk.enhanced.dynamodb.model.GetItemEnhancedRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItem;

@SdkPublicApi
public final class TransactGetItemsEnhancedRequest {
    private final List<TransactGetItem> transactGetItems;

    private TransactGetItemsEnhancedRequest(Builder builder) {
        this.transactGetItems = EnhancedClientUtils.getItemsFromSupplier(builder.itemSupplierList);
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<TransactGetItem> transactGetItems() {
        return this.transactGetItems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactGetItemsEnhancedRequest that = (TransactGetItemsEnhancedRequest)o;
        return this.transactGetItems != null ? this.transactGetItems.equals(that.transactGetItems) : that.transactGetItems == null;
    }

    public int hashCode() {
        return this.transactGetItems != null ? this.transactGetItems.hashCode() : 0;
    }

    public static final class Builder {
        private List<Supplier<TransactGetItem>> itemSupplierList = new ArrayList<Supplier<TransactGetItem>>();

        private Builder() {
        }

        public Builder addGetItem(MappedTableResource<?> mappedTableResource, GetItemEnhancedRequest request) {
            this.itemSupplierList.add(() -> this.generateTransactWriteItem(mappedTableResource, GetItemOperation.create(request)));
            return this;
        }

        public Builder addGetItem(MappedTableResource<?> mappedTableResource, Key key) {
            return this.addGetItem((MappedTableResource)mappedTableResource, (Object)GetItemEnhancedRequest.builder().key(key).build());
        }

        public <T> Builder addGetItem(MappedTableResource<T> mappedTableResource, T keyItem) {
            return this.addGetItem(mappedTableResource, (T)mappedTableResource.keyFrom(keyItem));
        }

        public TransactGetItemsEnhancedRequest build() {
            return new TransactGetItemsEnhancedRequest(this);
        }

        private <T> TransactGetItem generateTransactWriteItem(MappedTableResource<T> mappedTableResource, TransactableReadOperation<T> generator) {
            return generator.generateTransactGetItem(mappedTableResource.tableSchema(), DefaultOperationContext.create(mappedTableResource.tableName()), mappedTableResource.mapperExtension());
        }
    }
}

