/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.operations;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClientExtension;
import software.amazon.awssdk.enhanced.dynamodb.OperationContext;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@SdkInternalApi
public interface CommonOperation<ItemT, RequestT, ResponseT, ResultT> {
    public RequestT generateRequest(TableSchema<ItemT> var1, OperationContext var2, DynamoDbEnhancedClientExtension var3);

    public Function<RequestT, ResponseT> serviceCall(DynamoDbClient var1);

    public Function<RequestT, CompletableFuture<ResponseT>> asyncServiceCall(DynamoDbAsyncClient var1);

    public ResultT transformResponse(ResponseT var1, TableSchema<ItemT> var2, OperationContext var3, DynamoDbEnhancedClientExtension var4);

    default public ResultT execute(TableSchema<ItemT> tableSchema, OperationContext context, DynamoDbEnhancedClientExtension extension, DynamoDbClient dynamoDbClient) {
        RequestT request = this.generateRequest(tableSchema, context, extension);
        ResponseT response = this.serviceCall(dynamoDbClient).apply(request);
        return this.transformResponse(response, tableSchema, context, extension);
    }

    default public CompletableFuture<ResultT> executeAsync(TableSchema<ItemT> tableSchema, OperationContext context, DynamoDbEnhancedClientExtension extension, DynamoDbAsyncClient dynamoDbAsyncClient) {
        RequestT request = this.generateRequest(tableSchema, context, extension);
        CompletableFuture<ResponseT> response = this.asyncServiceCall(dynamoDbAsyncClient).apply(request);
        return response.thenApply(r -> this.transformResponse(r, tableSchema, context, extension));
    }
}

