/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.model;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbTable;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.DefaultOperationContext;
import software.amazon.awssdk.services.dynamodb.model.DeleteRequest;
import software.amazon.awssdk.services.dynamodb.model.PutRequest;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

@SdkPublicApi
public final class BatchWriteResult {
    private final Map<String, List<WriteRequest>> unprocessedRequests;

    private BatchWriteResult(Builder builder) {
        this.unprocessedRequests = Collections.unmodifiableMap(builder.unprocessedRequests);
    }

    public static Builder builder() {
        return new Builder();
    }

    public <T> List<T> unprocessedPutItemsForTable(DynamoDbTable<T> mappedTable) {
        List writeRequests = this.unprocessedRequests.getOrDefault(mappedTable.tableName(), Collections.emptyList());
        return writeRequests.stream().filter(writeRequest -> writeRequest.putRequest() != null).map(WriteRequest::putRequest).map(PutRequest::item).map(item -> EnhancedClientUtils.readAndTransformSingleItem(item, mappedTable.tableSchema(), DefaultOperationContext.create(mappedTable.tableName()), mappedTable.mapperExtension())).collect(Collectors.toList());
    }

    public List<Key> unprocessedDeleteItemsForTable(DynamoDbTable<?> mappedTable) {
        List writeRequests = this.unprocessedRequests.getOrDefault(mappedTable.tableName(), Collections.emptyList());
        return writeRequests.stream().filter(writeRequest -> writeRequest.deleteRequest() != null).map(WriteRequest::deleteRequest).map(DeleteRequest::key).map(itemMap -> EnhancedClientUtils.createKeyFromMap(itemMap, mappedTable.tableSchema(), TableMetadata.primaryIndexName())).collect(Collectors.toList());
    }

    public static final class Builder {
        private Map<String, List<WriteRequest>> unprocessedRequests;

        private Builder() {
        }

        public Builder unprocessedRequests(Map<String, List<WriteRequest>> unprocessedRequests) {
            this.unprocessedRequests = unprocessedRequests.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Collections.unmodifiableList((List)entry.getValue())));
            return this;
        }

        public BatchWriteResult build() {
            return new BatchWriteResult(this);
        }
    }
}

