/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.mapper;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;

@SdkPublicApi
public final class StaticTableMetadata
implements TableMetadata {
    private final Map<String, Object> customMetadata;
    private final Map<String, Index> indexByNameMap;
    private final Map<String, AttributeValueType> keyAttributes;

    private StaticTableMetadata(Builder builder) {
        this.customMetadata = Collections.unmodifiableMap(builder.customMetadata);
        this.indexByNameMap = Collections.unmodifiableMap(builder.indexByNameMap);
        this.keyAttributes = Collections.unmodifiableMap(builder.keyAttributes);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public <T> Optional<T> customMetadataObject(String key, Class<? extends T> objectClass) {
        Object genericObject = this.customMetadata.get(key);
        if (genericObject == null) {
            return Optional.empty();
        }
        if (!objectClass.isAssignableFrom(genericObject.getClass())) {
            throw new IllegalArgumentException("Attempt to retrieve a custom metadata object as a type that is not assignable for that object. Custom metadata key: " + key + "; requested object class: " + objectClass.getCanonicalName() + "; found object class: " + genericObject.getClass().getCanonicalName());
        }
        return Optional.of(objectClass.cast(genericObject));
    }

    @Override
    public String indexPartitionKey(String indexName) {
        Index index = this.getIndex(indexName);
        if (index.getIndexPartitionKey() == null) {
            if (!TableMetadata.primaryIndexName().equals(indexName) && index.getIndexSortKey() != null) {
                return this.primaryPartitionKey();
            }
            throw new IllegalArgumentException("Attempt to execute an operation against an index that requires a partition key without assigning a partition key to that index. Index name: " + indexName);
        }
        return index.getIndexPartitionKey();
    }

    @Override
    public Optional<String> indexSortKey(String indexName) {
        Index index = this.getIndex(indexName);
        return Optional.ofNullable(index.getIndexSortKey());
    }

    @Override
    public Collection<String> indexKeys(String indexName) {
        Index index = this.getIndex(indexName);
        if (index.getIndexSortKey() != null) {
            if (!TableMetadata.primaryIndexName().equals(indexName) && index.getIndexPartitionKey() == null) {
                return Collections.unmodifiableList(Arrays.asList(this.primaryPartitionKey(), index.getIndexSortKey()));
            }
            return Collections.unmodifiableList(Arrays.asList(index.getIndexPartitionKey(), index.getIndexSortKey()));
        }
        return Collections.singletonList(index.getIndexPartitionKey());
    }

    @Override
    public Collection<String> allKeys() {
        return this.keyAttributes.keySet();
    }

    private Index getIndex(String indexName) {
        Index index = this.indexByNameMap.get(indexName);
        if (index == null) {
            if (TableMetadata.primaryIndexName().equals(indexName)) {
                throw new IllegalArgumentException("Attempt to execute an operation that requires a primary index without defining any primary key attributes in the table metadata.");
            }
            throw new IllegalArgumentException("Attempt to execute an operation that requires a secondary index without defining the index attributes in the table metadata. Index name: " + indexName);
        }
        return index;
    }

    @Override
    public Optional<ScalarAttributeType> scalarAttributeType(String keyAttribute) {
        AttributeValueType attributeValueType = this.keyAttributes.get(keyAttribute);
        if (attributeValueType == null) {
            throw new IllegalArgumentException("Key attribute '" + keyAttribute + "' not found in table metadata.");
        }
        return Optional.ofNullable(attributeValueType.scalarAttributeType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StaticTableMetadata that = (StaticTableMetadata)o;
        if (this.customMetadata != null ? !this.customMetadata.equals(that.customMetadata) : that.customMetadata != null) {
            return false;
        }
        if (this.indexByNameMap != null ? !this.indexByNameMap.equals(that.indexByNameMap) : that.indexByNameMap != null) {
            return false;
        }
        return this.keyAttributes != null ? this.keyAttributes.equals(that.keyAttributes) : that.keyAttributes == null;
    }

    public int hashCode() {
        int result = this.customMetadata != null ? this.customMetadata.hashCode() : 0;
        result = 31 * result + (this.indexByNameMap != null ? this.indexByNameMap.hashCode() : 0);
        result = 31 * result + (this.keyAttributes != null ? this.keyAttributes.hashCode() : 0);
        return result;
    }

    private static class Index {
        private final String indexName;
        private String indexPartitionKey;
        private String indexSortKey;
        private AttributeValueType indexPartitionType;
        private AttributeValueType indexSortType;

        private Index(String indexName) {
            this.indexName = indexName;
        }

        private String getIndexName() {
            return this.indexName;
        }

        private String getIndexPartitionKey() {
            return this.indexPartitionKey;
        }

        private String getIndexSortKey() {
            return this.indexSortKey;
        }

        private AttributeValueType getIndexPartitionType() {
            return this.indexPartitionType;
        }

        private AttributeValueType getIndexSortType() {
            return this.indexSortType;
        }

        private void setIndexPartitionKey(String indexPartitionKey) {
            this.indexPartitionKey = indexPartitionKey;
        }

        private void setIndexSortKey(String indexSortKey) {
            this.indexSortKey = indexSortKey;
        }

        private void setIndexPartitionType(AttributeValueType indexPartitionType) {
            this.indexPartitionType = indexPartitionType;
        }

        private void setIndexSortType(AttributeValueType indexSortType) {
            this.indexSortType = indexSortType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Index index = (Index)o;
            if (this.indexName != null ? !this.indexName.equals(index.indexName) : index.indexName != null) {
                return false;
            }
            if (this.indexPartitionKey != null ? !this.indexPartitionKey.equals(index.indexPartitionKey) : index.indexPartitionKey != null) {
                return false;
            }
            if (this.indexSortKey != null ? !this.indexSortKey.equals(index.indexSortKey) : index.indexSortKey != null) {
                return false;
            }
            if (this.indexPartitionType != index.indexPartitionType) {
                return false;
            }
            return this.indexSortType == index.indexSortType;
        }

        public int hashCode() {
            int result = this.indexName != null ? this.indexName.hashCode() : 0;
            result = 31 * result + (this.indexPartitionKey != null ? this.indexPartitionKey.hashCode() : 0);
            result = 31 * result + (this.indexSortKey != null ? this.indexSortKey.hashCode() : 0);
            result = 31 * result + (this.indexPartitionType != null ? this.indexPartitionType.hashCode() : 0);
            result = 31 * result + (this.indexSortType != null ? this.indexSortType.hashCode() : 0);
            return result;
        }
    }

    public static class Builder {
        private final Map<String, Object> customMetadata = new HashMap<String, Object>();
        private final Map<String, Index> indexByNameMap = new HashMap<String, Index>();
        private final Map<String, AttributeValueType> keyAttributes = new HashMap<String, AttributeValueType>();

        private Builder() {
        }

        public StaticTableMetadata build() {
            return new StaticTableMetadata(this);
        }

        public Builder addCustomMetadataObject(String key, Object object) {
            if (this.customMetadata.containsKey(key)) {
                throw new IllegalArgumentException("Attempt to set a custom metadata object that has already been set. Custom metadata object key: " + key);
            }
            this.customMetadata.put(key, object);
            return this;
        }

        public Builder addIndexPartitionKey(String indexName, String attributeName, AttributeValueType attributeValueType) {
            Index index = this.indexByNameMap.computeIfAbsent(indexName, $ -> new Index(indexName));
            if (index.getIndexPartitionKey() != null) {
                throw new IllegalArgumentException("Attempt to set an index partition key that conflicts with an existing index partition key of the same name and index. Index name: " + indexName + "; attribute name: " + attributeName);
            }
            index.setIndexPartitionKey(attributeName);
            index.setIndexPartitionType(attributeValueType);
            this.markAttributeAsKey(attributeName, attributeValueType);
            return this;
        }

        public Builder addIndexSortKey(String indexName, String attributeName, AttributeValueType attributeValueType) {
            Index index = this.indexByNameMap.computeIfAbsent(indexName, $ -> new Index(indexName));
            if (index.getIndexSortKey() != null) {
                throw new IllegalArgumentException("Attempt to set an index sort key that conflicts with an existing index sort key of the same name and index. Index name: " + indexName + "; attribute name: " + attributeName);
            }
            index.setIndexSortKey(attributeName);
            index.setIndexSortType(attributeValueType);
            this.markAttributeAsKey(attributeName, attributeValueType);
            return this;
        }

        public Builder markAttributeAsKey(String attributeName, AttributeValueType attributeValueType) {
            AttributeValueType existing = this.keyAttributes.get(attributeName);
            if (existing != null && !existing.equals((Object)attributeValueType)) {
                throw new IllegalArgumentException("Attempt to mark an attribute as a key with a different AttributeValueType than one that has already been recorded.");
            }
            if (existing == null) {
                this.keyAttributes.put(attributeName, attributeValueType);
            }
            return this;
        }

        Builder mergeWith(StaticTableMetadata other) {
            other.indexByNameMap.forEach((key, index) -> {
                if (((Index)index).getIndexPartitionKey() != null) {
                    this.addIndexPartitionKey(((Index)index).getIndexName(), ((Index)index).getIndexPartitionKey(), ((Index)index).getIndexPartitionType());
                }
                if (((Index)index).getIndexSortKey() != null) {
                    this.addIndexSortKey(((Index)index).getIndexName(), ((Index)index).getIndexSortKey(), ((Index)index).getIndexSortType());
                }
            });
            other.customMetadata.forEach(this::addCustomMetadataObject);
            other.keyAttributes.forEach(this::markAttributeAsKey);
            return this;
        }
    }
}

