/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.DefaultParameterizedType;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
@ThreadSafe
@Immutable
public class EnhancedType<T> {
    private final boolean isWildcard;
    private final Class<T> rawClass;
    private final List<EnhancedType<?>> rawClassParameters;
    private final TableSchema<T> tableSchema;

    protected EnhancedType() {
        this(null);
    }

    private EnhancedType(Type type) {
        if (type == null) {
            type = this.captureGenericTypeArguments();
        }
        if (type instanceof WildcardType) {
            this.isWildcard = true;
            this.rawClass = null;
            this.rawClassParameters = null;
            this.tableSchema = null;
        } else {
            this.isWildcard = false;
            this.rawClass = this.validateAndConvert(type);
            this.rawClassParameters = this.loadTypeParameters(type);
            this.tableSchema = null;
        }
    }

    private EnhancedType(Class<?> rawClass, List<EnhancedType<?>> rawClassParameters, TableSchema<T> tableSchema) {
        this.rawClass = rawClass;
        this.isWildcard = false;
        this.rawClassParameters = rawClassParameters;
        this.tableSchema = tableSchema;
    }

    public static <T> EnhancedType<T> of(Class<T> type) {
        return new EnhancedType<T>(type);
    }

    public static EnhancedType<?> of(Type type) {
        return new EnhancedType(type);
    }

    public static <T> EnhancedType<Optional<T>> optionalOf(Class<T> valueType) {
        return new EnhancedType<Optional<T>>(DefaultParameterizedType.parameterizedType(Optional.class, valueType));
    }

    public static <T> EnhancedType<List<T>> listOf(Class<T> valueType) {
        return new EnhancedType<List<T>>(DefaultParameterizedType.parameterizedType(List.class, valueType));
    }

    public static <T> EnhancedType<List<T>> listOf(EnhancedType<T> valueType) {
        return new EnhancedType<List<T>>(List.class, Arrays.asList(valueType), null);
    }

    public static <T> EnhancedType<Set<T>> setOf(Class<T> valueType) {
        return new EnhancedType<Set<T>>(DefaultParameterizedType.parameterizedType(Set.class, valueType));
    }

    public static <T> EnhancedType<Set<T>> setOf(EnhancedType<T> valueType) {
        return new EnhancedType<Set<T>>(Set.class, Arrays.asList(valueType), null);
    }

    public static <T> EnhancedType<SortedSet<T>> sortedSetOf(Class<T> valueType) {
        return new EnhancedType<SortedSet<T>>(DefaultParameterizedType.parameterizedType(SortedSet.class, valueType));
    }

    public static <T> EnhancedType<SortedSet<T>> sortedSetOf(EnhancedType<T> valueType) {
        return new EnhancedType<SortedSet<T>>(SortedSet.class, Arrays.asList(valueType), null);
    }

    public static <T> EnhancedType<Deque<T>> dequeOf(Class<T> valueType) {
        return new EnhancedType<Deque<T>>(DefaultParameterizedType.parameterizedType(Deque.class, valueType));
    }

    public static <T> EnhancedType<Deque<T>> dequeOf(EnhancedType<T> valueType) {
        return new EnhancedType<Deque<T>>(Deque.class, Arrays.asList(valueType), null);
    }

    public static <T> EnhancedType<NavigableSet<T>> navigableSetOf(Class<T> valueType) {
        return new EnhancedType<NavigableSet<T>>(DefaultParameterizedType.parameterizedType(NavigableSet.class, valueType));
    }

    public static <T> EnhancedType<NavigableSet<T>> navigableSetOf(EnhancedType<T> valueType) {
        return new EnhancedType<NavigableSet<T>>(NavigableSet.class, Arrays.asList(valueType), null);
    }

    public static <T> EnhancedType<Collection<T>> collectionOf(Class<T> valueType) {
        return new EnhancedType<Collection<T>>(DefaultParameterizedType.parameterizedType(Collection.class, valueType));
    }

    public static <T> EnhancedType<Collection<T>> collectionOf(EnhancedType<T> valueType) {
        return new EnhancedType<Collection<T>>(Collection.class, Arrays.asList(valueType), null);
    }

    public static <T, U> EnhancedType<Map<T, U>> mapOf(Class<T> keyType, Class<U> valueType) {
        return new EnhancedType<Map<T, U>>(DefaultParameterizedType.parameterizedType(Map.class, keyType, valueType));
    }

    public static <T, U> EnhancedType<Map<T, U>> mapOf(EnhancedType<T> keyType, EnhancedType<U> valueType) {
        return new EnhancedType<Map<T, U>>(Map.class, Arrays.asList(keyType, valueType), null);
    }

    public static <T, U> EnhancedType<SortedMap<T, U>> sortedMapOf(Class<T> keyType, Class<U> valueType) {
        return new EnhancedType<SortedMap<T, U>>(DefaultParameterizedType.parameterizedType(SortedMap.class, keyType, valueType));
    }

    public static <T, U> EnhancedType<SortedMap<T, U>> sortedMapOf(EnhancedType<T> keyType, EnhancedType<U> valueType) {
        return new EnhancedType<SortedMap<T, U>>(SortedMap.class, Arrays.asList(keyType, valueType), null);
    }

    public static <T, U> EnhancedType<ConcurrentMap<T, U>> concurrentMapOf(Class<T> keyType, Class<U> valueType) {
        return new EnhancedType<ConcurrentMap<T, U>>(DefaultParameterizedType.parameterizedType(ConcurrentMap.class, keyType, valueType));
    }

    public static <T, U> EnhancedType<ConcurrentMap<T, U>> concurrentMapOf(EnhancedType<T> keyType, EnhancedType<U> valueType) {
        return new EnhancedType<ConcurrentMap<T, U>>(ConcurrentMap.class, Arrays.asList(keyType, valueType), null);
    }

    public static <T, U> EnhancedType<NavigableMap<T, U>> navigableMapOf(Class<T> keyType, Class<U> valueType) {
        return new EnhancedType<NavigableMap<T, U>>(DefaultParameterizedType.parameterizedType(NavigableMap.class, keyType, valueType));
    }

    public static <T, U> EnhancedType<NavigableMap<T, U>> navigableMapOf(EnhancedType<T> keyType, EnhancedType<U> valueType) {
        return new EnhancedType<NavigableMap<T, U>>(NavigableMap.class, Arrays.asList(keyType, valueType), null);
    }

    public static <T> EnhancedType<T> documentOf(Class<T> documentClass, TableSchema<T> documentTableSchema) {
        return new EnhancedType<T>(documentClass, null, documentTableSchema);
    }

    private static Type validateIsSupportedType(Type type) {
        Validate.validState((type != null ? 1 : 0) != 0, (String)"Type must not be null.", (Object[])new Object[0]);
        Validate.validState((!(type instanceof GenericArrayType) ? 1 : 0) != 0, (String)"Array type %s is not supported. Use java.util.List instead of arrays.", (Object[])new Object[]{type});
        Validate.validState((!(type instanceof TypeVariable) ? 1 : 0) != 0, (String)"Type variable type %s is not supported.", (Object[])new Object[]{type});
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Validate.validState((wildcardType.getUpperBounds().length == 1 && wildcardType.getUpperBounds()[0] == Object.class ? 1 : 0) != 0, (String)"Non-Object wildcard type upper bounds are not supported.", (Object[])new Object[0]);
            Validate.validState((wildcardType.getLowerBounds().length == 0 ? 1 : 0) != 0, (String)"Wildcard type lower bounds are not supported.", (Object[])new Object[0]);
        }
        return type;
    }

    public boolean isWildcard() {
        return this.isWildcard;
    }

    public Class<T> rawClass() {
        Validate.isTrue((!this.isWildcard ? 1 : 0) != 0, (String)"A wildcard type is not expected here.", (Object[])new Object[0]);
        return this.rawClass;
    }

    public Optional<TableSchema<T>> tableSchema() {
        return Optional.ofNullable(this.tableSchema);
    }

    public List<EnhancedType<?>> rawClassParameters() {
        Validate.isTrue((!this.isWildcard ? 1 : 0) != 0, (String)"A wildcard type is not expected here.", (Object[])new Object[0]);
        return this.rawClassParameters;
    }

    private Type captureGenericTypeArguments() {
        Type superclass = this.getClass().getGenericSuperclass();
        ParameterizedType parameterizedSuperclass = (ParameterizedType)Validate.isInstanceOf(ParameterizedType.class, (Object)superclass, (String)"%s isn't parameterized", (Object[])new Object[]{superclass});
        return parameterizedSuperclass.getActualTypeArguments()[0];
    }

    private Class<T> validateAndConvert(Type type) {
        EnhancedType.validateIsSupportedType(type);
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return this.validateAndConvert(parameterizedType.getRawType());
        }
        throw new IllegalStateException("Unsupported type: " + type);
    }

    private List<EnhancedType<?>> loadTypeParameters(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return Collections.emptyList();
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        return Collections.unmodifiableList(Arrays.stream(parameterizedType.getActualTypeArguments()).peek(t -> Validate.validState((t != null ? 1 : 0) != 0, (String)"Invalid type argument.", (Object[])new Object[0])).map(EnhancedType::new).collect(Collectors.toList()));
    }

    private StringBuilder innerToString() {
        StringBuilder result = new StringBuilder();
        result.append(this.rawClass.getTypeName());
        if (null != this.rawClassParameters && !this.rawClassParameters.isEmpty()) {
            result.append("<");
            result.append(this.rawClassParameters.stream().map(EnhancedType::innerToString).collect(Collectors.joining(", ")));
            result.append(">");
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EnhancedType)) {
            return false;
        }
        EnhancedType enhancedType = (EnhancedType)o;
        if (this.isWildcard != enhancedType.isWildcard) {
            return false;
        }
        if (!this.rawClass.equals(enhancedType.rawClass)) {
            return false;
        }
        if (this.rawClassParameters != null ? !this.rawClassParameters.equals(enhancedType.rawClassParameters) : enhancedType.rawClassParameters != null) {
            return false;
        }
        return this.tableSchema != null ? this.tableSchema.equals(enhancedType.tableSchema) : enhancedType.tableSchema == null;
    }

    public int hashCode() {
        int result = this.isWildcard ? 1 : 0;
        result = 31 * result + this.rawClass.hashCode();
        result = 31 * result + (this.rawClassParameters != null ? this.rawClassParameters.hashCode() : 0);
        result = 31 * result + (this.tableSchema != null ? this.tableSchema.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "EnhancedType(" + this.innerToString() + ")";
    }
}

