/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LaunchActionType {
    SSM_AUTOMATION("SSM_AUTOMATION"),
    SSM_COMMAND("SSM_COMMAND"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LaunchActionType> VALUE_MAP;
    private final String value;

    private LaunchActionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LaunchActionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LaunchActionType> knownValues() {
        EnumSet<LaunchActionType> knownValues = EnumSet.allOf(LaunchActionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LaunchActionType.class, LaunchActionType::toString);
    }
}

