/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.drs.model.RecoveryResult;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecoveryLifeCycle
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecoveryLifeCycle> {
    private static final SdkField<Instant> API_CALL_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("apiCallDateTime").getter(RecoveryLifeCycle.getter(RecoveryLifeCycle::apiCallDateTime)).setter(RecoveryLifeCycle.setter(Builder::apiCallDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiCallDateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobID").getter(RecoveryLifeCycle.getter(RecoveryLifeCycle::jobID)).setter(RecoveryLifeCycle.setter(Builder::jobID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobID").build()}).build();
    private static final SdkField<String> LAST_RECOVERY_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastRecoveryResult").getter(RecoveryLifeCycle.getter(RecoveryLifeCycle::lastRecoveryResultAsString)).setter(RecoveryLifeCycle.setter(Builder::lastRecoveryResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRecoveryResult").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_CALL_DATE_TIME_FIELD, JOB_ID_FIELD, LAST_RECOVERY_RESULT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant apiCallDateTime;
    private final String jobID;
    private final String lastRecoveryResult;

    private RecoveryLifeCycle(BuilderImpl builder) {
        this.apiCallDateTime = builder.apiCallDateTime;
        this.jobID = builder.jobID;
        this.lastRecoveryResult = builder.lastRecoveryResult;
    }

    public final Instant apiCallDateTime() {
        return this.apiCallDateTime;
    }

    public final String jobID() {
        return this.jobID;
    }

    public final RecoveryResult lastRecoveryResult() {
        return RecoveryResult.fromValue(this.lastRecoveryResult);
    }

    public final String lastRecoveryResultAsString() {
        return this.lastRecoveryResult;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apiCallDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobID());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRecoveryResultAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecoveryLifeCycle)) {
            return false;
        }
        RecoveryLifeCycle other = (RecoveryLifeCycle)obj;
        return Objects.equals(this.apiCallDateTime(), other.apiCallDateTime()) && Objects.equals(this.jobID(), other.jobID()) && Objects.equals(this.lastRecoveryResultAsString(), other.lastRecoveryResultAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RecoveryLifeCycle").add("ApiCallDateTime", (Object)this.apiCallDateTime()).add("JobID", (Object)this.jobID()).add("LastRecoveryResult", (Object)this.lastRecoveryResultAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "apiCallDateTime": {
                return Optional.ofNullable(clazz.cast(this.apiCallDateTime()));
            }
            case "jobID": {
                return Optional.ofNullable(clazz.cast(this.jobID()));
            }
            case "lastRecoveryResult": {
                return Optional.ofNullable(clazz.cast(this.lastRecoveryResultAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecoveryLifeCycle, T> g) {
        return obj -> g.apply((RecoveryLifeCycle)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant apiCallDateTime;
        private String jobID;
        private String lastRecoveryResult;

        private BuilderImpl() {
        }

        private BuilderImpl(RecoveryLifeCycle model) {
            this.apiCallDateTime(model.apiCallDateTime);
            this.jobID(model.jobID);
            this.lastRecoveryResult(model.lastRecoveryResult);
        }

        public final Instant getApiCallDateTime() {
            return this.apiCallDateTime;
        }

        public final void setApiCallDateTime(Instant apiCallDateTime) {
            this.apiCallDateTime = apiCallDateTime;
        }

        @Override
        public final Builder apiCallDateTime(Instant apiCallDateTime) {
            this.apiCallDateTime = apiCallDateTime;
            return this;
        }

        public final String getJobID() {
            return this.jobID;
        }

        public final void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @Override
        public final Builder jobID(String jobID) {
            this.jobID = jobID;
            return this;
        }

        public final String getLastRecoveryResult() {
            return this.lastRecoveryResult;
        }

        public final void setLastRecoveryResult(String lastRecoveryResult) {
            this.lastRecoveryResult = lastRecoveryResult;
        }

        @Override
        public final Builder lastRecoveryResult(String lastRecoveryResult) {
            this.lastRecoveryResult = lastRecoveryResult;
            return this;
        }

        @Override
        public final Builder lastRecoveryResult(RecoveryResult lastRecoveryResult) {
            this.lastRecoveryResult(lastRecoveryResult == null ? null : lastRecoveryResult.toString());
            return this;
        }

        public RecoveryLifeCycle build() {
            return new RecoveryLifeCycle(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecoveryLifeCycle> {
        public Builder apiCallDateTime(Instant var1);

        public Builder jobID(String var1);

        public Builder lastRecoveryResult(String var1);

        public Builder lastRecoveryResult(RecoveryResult var1);
    }
}

