/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ProductCodeMode {
    ENABLED("ENABLED"),
    DISABLED("DISABLED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ProductCodeMode> VALUE_MAP;
    private final String value;

    private ProductCodeMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ProductCodeMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ProductCodeMode> knownValues() {
        EnumSet<ProductCodeMode> knownValues = EnumSet.allOf(ProductCodeMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ProductCodeMode.class, ProductCodeMode::toString);
    }
}

