/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdbelastic.endpoints.internal;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.docdbelastic.endpoints.DocDbElasticEndpointParams;
import software.amazon.awssdk.services.docdbelastic.endpoints.DocDbElasticEndpointProvider;
import software.amazon.awssdk.services.docdbelastic.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.docdbelastic.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.docdbelastic.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultDocDbElasticEndpointProvider
implements DocDbElasticEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(DocDbElasticEndpointParams params) {
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            Region region = params.region();
            String regionId = region == null ? null : region.id();
            RuleResult result = DefaultDocDbElasticEndpointProvider.endpointRule0(params, regionId);
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(DocDbElasticEndpointParams params, String region) {
        RuleResult result = DefaultDocDbElasticEndpointProvider.endpointRule1(params);
        if (result.isResolved()) {
            return result;
        }
        return DefaultDocDbElasticEndpointProvider.endpointRule6(params, region);
    }

    private static RuleResult endpointRule1(DocDbElasticEndpointParams params) {
        if (params.endpoint() != null) {
            if (params.useFips().booleanValue()) {
                return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
            }
            return DefaultDocDbElasticEndpointProvider.endpointRule3(params);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule3(DocDbElasticEndpointParams params) {
        if (params.useDualStack().booleanValue()) {
            return RuleResult.error("Invalid Configuration: Dualstack and custom endpoint are not supported");
        }
        return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
    }

    private static RuleResult endpointRule6(DocDbElasticEndpointParams params, String region) {
        RuleResult result = DefaultDocDbElasticEndpointProvider.endpointRule7(params, region);
        if (result.isResolved()) {
            return result;
        }
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    private static RuleResult endpointRule7(DocDbElasticEndpointParams params, String region) {
        if (region != null) {
            return DefaultDocDbElasticEndpointProvider.endpointRule8(params, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule8(DocDbElasticEndpointParams params, String region) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            RuleResult result = DefaultDocDbElasticEndpointProvider.endpointRule9(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultDocDbElasticEndpointProvider.endpointRule14(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultDocDbElasticEndpointProvider.endpointRule19(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return DefaultDocDbElasticEndpointProvider.endpointRule24(params, region, partitionResult);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule9(DocDbElasticEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultDocDbElasticEndpointProvider.endpointRule10(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS and DualStack are enabled, but this partition does not support one or both");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule10(DocDbElasticEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsFIPS() && partitionResult.supportsDualStack()) {
            return DefaultDocDbElasticEndpointProvider.endpointRule11(params, region, partitionResult);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule11(DocDbElasticEndpointParams params, String region, RulePartition partitionResult) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://docdb-elastic-fips." + region + "." + partitionResult.dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule14(DocDbElasticEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultDocDbElasticEndpointProvider.endpointRule15(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule15(DocDbElasticEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsFIPS()) {
            return DefaultDocDbElasticEndpointProvider.endpointRule16(params, region, partitionResult);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule16(DocDbElasticEndpointParams params, String region, RulePartition partitionResult) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://docdb-elastic-fips." + region + "." + partitionResult.dnsSuffix())).build());
    }

    private static RuleResult endpointRule19(DocDbElasticEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultDocDbElasticEndpointProvider.endpointRule20(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule20(DocDbElasticEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsDualStack()) {
            return DefaultDocDbElasticEndpointProvider.endpointRule21(params, region, partitionResult);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule21(DocDbElasticEndpointParams params, String region, RulePartition partitionResult) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://docdb-elastic." + region + "." + partitionResult.dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule24(DocDbElasticEndpointParams params, String region, RulePartition partitionResult) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://docdb-elastic." + region + "." + partitionResult.dnsSuffix())).build());
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

