/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdbelastic.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Status {
    CREATING("CREATING"),
    ACTIVE("ACTIVE"),
    DELETING("DELETING"),
    UPDATING("UPDATING"),
    VPC_ENDPOINT_LIMIT_EXCEEDED("VPC_ENDPOINT_LIMIT_EXCEEDED"),
    IP_ADDRESS_LIMIT_EXCEEDED("IP_ADDRESS_LIMIT_EXCEEDED"),
    INVALID_SECURITY_GROUP_ID("INVALID_SECURITY_GROUP_ID"),
    INVALID_SUBNET_ID("INVALID_SUBNET_ID"),
    INACCESSIBLE_ENCRYPTION_CREDS("INACCESSIBLE_ENCRYPTION_CREDS"),
    INACCESSIBLE_SECRET_ARN("INACCESSIBLE_SECRET_ARN"),
    INACCESSIBLE_VPC_ENDPOINT("INACCESSIBLE_VPC_ENDPOINT"),
    INCOMPATIBLE_NETWORK("INCOMPATIBLE_NETWORK"),
    MERGING("MERGING"),
    MODIFYING("MODIFYING"),
    SPLITTING("SPLITTING"),
    COPYING("COPYING"),
    STARTING("STARTING"),
    STOPPING("STOPPING"),
    STOPPED("STOPPED"),
    MAINTENANCE("MAINTENANCE"),
    INACCESSIBLE_ENCRYPTION_CREDENTIALS_RECOVERABLE("INACCESSIBLE_ENCRYPTION_CREDENTIALS_RECOVERABLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Status> VALUE_MAP;
    private final String value;

    private Status(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Status fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Status> knownValues() {
        EnumSet<Status> knownValues = EnumSet.allOf(Status.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Status.class, Status::toString);
    }
}

