/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdbelastic.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.docdbelastic.model.ClusterSnapshotInList;
import software.amazon.awssdk.services.docdbelastic.model.ClusterSnapshotListCopier;
import software.amazon.awssdk.services.docdbelastic.model.DocDbElasticResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListClusterSnapshotsResponse
extends DocDbElasticResponse
implements ToCopyableBuilder<Builder, ListClusterSnapshotsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListClusterSnapshotsResponse.getter(ListClusterSnapshotsResponse::nextToken)).setter(ListClusterSnapshotsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ClusterSnapshotInList>> SNAPSHOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("snapshots").getter(ListClusterSnapshotsResponse.getter(ListClusterSnapshotsResponse::snapshots)).setter(ListClusterSnapshotsResponse.setter(Builder::snapshots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshots").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterSnapshotInList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SNAPSHOTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("snapshots", SNAPSHOTS_FIELD);
        }
    });
    private final String nextToken;
    private final List<ClusterSnapshotInList> snapshots;

    private ListClusterSnapshotsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.snapshots = builder.snapshots;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasSnapshots() {
        return this.snapshots != null && !(this.snapshots instanceof SdkAutoConstructList);
    }

    public final List<ClusterSnapshotInList> snapshots() {
        return this.snapshots;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSnapshots() ? this.snapshots() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClusterSnapshotsResponse)) {
            return false;
        }
        ListClusterSnapshotsResponse other = (ListClusterSnapshotsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasSnapshots() == other.hasSnapshots() && Objects.equals(this.snapshots(), other.snapshots());
    }

    public final String toString() {
        return ToString.builder((String)"ListClusterSnapshotsResponse").add("NextToken", (Object)this.nextToken()).add("Snapshots", this.hasSnapshots() ? this.snapshots() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "snapshots": {
                return Optional.ofNullable(clazz.cast(this.snapshots()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListClusterSnapshotsResponse, T> g) {
        return obj -> g.apply((ListClusterSnapshotsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DocDbElasticResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ClusterSnapshotInList> snapshots = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListClusterSnapshotsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.snapshots(model.snapshots);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ClusterSnapshotInList.Builder> getSnapshots() {
            List<ClusterSnapshotInList.Builder> result = ClusterSnapshotListCopier.copyToBuilder(this.snapshots);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSnapshots(Collection<ClusterSnapshotInList.BuilderImpl> snapshots) {
            this.snapshots = ClusterSnapshotListCopier.copyFromBuilder(snapshots);
        }

        @Override
        public final Builder snapshots(Collection<ClusterSnapshotInList> snapshots) {
            this.snapshots = ClusterSnapshotListCopier.copy(snapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshots(ClusterSnapshotInList ... snapshots) {
            this.snapshots(Arrays.asList(snapshots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshots(Consumer<ClusterSnapshotInList.Builder> ... snapshots) {
            this.snapshots(Stream.of(snapshots).map(c -> (ClusterSnapshotInList)((ClusterSnapshotInList.Builder)ClusterSnapshotInList.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListClusterSnapshotsResponse build() {
            return new ListClusterSnapshotsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DocDbElasticResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListClusterSnapshotsResponse> {
        public Builder nextToken(String var1);

        public Builder snapshots(Collection<ClusterSnapshotInList> var1);

        public Builder snapshots(ClusterSnapshotInList ... var1);

        public Builder snapshots(Consumer<ClusterSnapshotInList.Builder> ... var1);
    }
}

