/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.docdb.model.DBClusterSnapshot;
import software.amazon.awssdk.services.docdb.model.DBClusterSnapshotListCopier;
import software.amazon.awssdk.services.docdb.model.DocDbResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDbClusterSnapshotsResponse
extends DocDbResponse
implements ToCopyableBuilder<Builder, DescribeDbClusterSnapshotsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDbClusterSnapshotsResponse.getter(DescribeDbClusterSnapshotsResponse::marker)).setter(DescribeDbClusterSnapshotsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<DBClusterSnapshot>> DB_CLUSTER_SNAPSHOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeDbClusterSnapshotsResponse.getter(DescribeDbClusterSnapshotsResponse::dbClusterSnapshots)).setter(DescribeDbClusterSnapshotsResponse.setter(Builder::dbClusterSnapshots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterSnapshots").build(), ListTrait.builder().memberLocationName("DBClusterSnapshot").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBClusterSnapshot::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterSnapshot").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, DB_CLUSTER_SNAPSHOTS_FIELD));
    private final String marker;
    private final List<DBClusterSnapshot> dbClusterSnapshots;

    private DescribeDbClusterSnapshotsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbClusterSnapshots = builder.dbClusterSnapshots;
    }

    public String marker() {
        return this.marker;
    }

    public List<DBClusterSnapshot> dbClusterSnapshots() {
        return this.dbClusterSnapshots;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterSnapshots());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbClusterSnapshotsResponse)) {
            return false;
        }
        DescribeDbClusterSnapshotsResponse other = (DescribeDbClusterSnapshotsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.dbClusterSnapshots(), other.dbClusterSnapshots());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDbClusterSnapshotsResponse").add("Marker", (Object)this.marker()).add("DBClusterSnapshots", this.dbClusterSnapshots()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "DBClusterSnapshots": {
                return Optional.ofNullable(clazz.cast(this.dbClusterSnapshots()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbClusterSnapshotsResponse, T> g) {
        return obj -> g.apply((DescribeDbClusterSnapshotsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DocDbResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<DBClusterSnapshot> dbClusterSnapshots = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbClusterSnapshotsResponse model) {
            super(model);
            this.marker(model.marker);
            this.dbClusterSnapshots(model.dbClusterSnapshots);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<DBClusterSnapshot.Builder> getDbClusterSnapshots() {
            return this.dbClusterSnapshots != null ? (Collection)this.dbClusterSnapshots.stream().map(DBClusterSnapshot::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbClusterSnapshots(Collection<DBClusterSnapshot> dbClusterSnapshots) {
            this.dbClusterSnapshots = DBClusterSnapshotListCopier.copy(dbClusterSnapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterSnapshots(DBClusterSnapshot ... dbClusterSnapshots) {
            this.dbClusterSnapshots(Arrays.asList(dbClusterSnapshots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterSnapshots(Consumer<DBClusterSnapshot.Builder> ... dbClusterSnapshots) {
            this.dbClusterSnapshots(Stream.of(dbClusterSnapshots).map(c -> (DBClusterSnapshot)((DBClusterSnapshot.Builder)DBClusterSnapshot.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDbClusterSnapshots(Collection<DBClusterSnapshot.BuilderImpl> dbClusterSnapshots) {
            this.dbClusterSnapshots = DBClusterSnapshotListCopier.copyFromBuilder(dbClusterSnapshots);
        }

        @Override
        public DescribeDbClusterSnapshotsResponse build() {
            return new DescribeDbClusterSnapshotsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DocDbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDbClusterSnapshotsResponse> {
        public Builder marker(String var1);

        public Builder dbClusterSnapshots(Collection<DBClusterSnapshot> var1);

        public Builder dbClusterSnapshots(DBClusterSnapshot ... var1);

        public Builder dbClusterSnapshots(Consumer<DBClusterSnapshot.Builder> ... var1);
    }
}

