/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.docdb.model.DBClusterSnapshotAttribute;
import software.amazon.awssdk.services.docdb.model.DBClusterSnapshotAttributeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DBClusterSnapshotAttributesResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DBClusterSnapshotAttributesResult> {
    private static final SdkField<String> DB_CLUSTER_SNAPSHOT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterSnapshotIdentifier").getter(DBClusterSnapshotAttributesResult.getter(DBClusterSnapshotAttributesResult::dbClusterSnapshotIdentifier)).setter(DBClusterSnapshotAttributesResult.setter(Builder::dbClusterSnapshotIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterSnapshotIdentifier").build()}).build();
    private static final SdkField<List<DBClusterSnapshotAttribute>> DB_CLUSTER_SNAPSHOT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DBClusterSnapshotAttributes").getter(DBClusterSnapshotAttributesResult.getter(DBClusterSnapshotAttributesResult::dbClusterSnapshotAttributes)).setter(DBClusterSnapshotAttributesResult.setter(Builder::dbClusterSnapshotAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterSnapshotAttributes").build(), ListTrait.builder().memberLocationName("DBClusterSnapshotAttribute").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBClusterSnapshotAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterSnapshotAttribute").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_SNAPSHOT_IDENTIFIER_FIELD, DB_CLUSTER_SNAPSHOT_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DBClusterSnapshotAttributesResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dbClusterSnapshotIdentifier;
    private final List<DBClusterSnapshotAttribute> dbClusterSnapshotAttributes;

    private DBClusterSnapshotAttributesResult(BuilderImpl builder) {
        this.dbClusterSnapshotIdentifier = builder.dbClusterSnapshotIdentifier;
        this.dbClusterSnapshotAttributes = builder.dbClusterSnapshotAttributes;
    }

    public final String dbClusterSnapshotIdentifier() {
        return this.dbClusterSnapshotIdentifier;
    }

    public final boolean hasDbClusterSnapshotAttributes() {
        return this.dbClusterSnapshotAttributes != null && !(this.dbClusterSnapshotAttributes instanceof SdkAutoConstructList);
    }

    public final List<DBClusterSnapshotAttribute> dbClusterSnapshotAttributes() {
        return this.dbClusterSnapshotAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbClusterSnapshotAttributes() ? this.dbClusterSnapshotAttributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBClusterSnapshotAttributesResult)) {
            return false;
        }
        DBClusterSnapshotAttributesResult other = (DBClusterSnapshotAttributesResult)obj;
        return Objects.equals(this.dbClusterSnapshotIdentifier(), other.dbClusterSnapshotIdentifier()) && this.hasDbClusterSnapshotAttributes() == other.hasDbClusterSnapshotAttributes() && Objects.equals(this.dbClusterSnapshotAttributes(), other.dbClusterSnapshotAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"DBClusterSnapshotAttributesResult").add("DBClusterSnapshotIdentifier", (Object)this.dbClusterSnapshotIdentifier()).add("DBClusterSnapshotAttributes", this.hasDbClusterSnapshotAttributes() ? this.dbClusterSnapshotAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBClusterSnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterSnapshotIdentifier()));
            }
            case "DBClusterSnapshotAttributes": {
                return Optional.ofNullable(clazz.cast(this.dbClusterSnapshotAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DBClusterSnapshotIdentifier", DB_CLUSTER_SNAPSHOT_IDENTIFIER_FIELD);
        map.put("DBClusterSnapshotAttributes", DB_CLUSTER_SNAPSHOT_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DBClusterSnapshotAttributesResult, T> g) {
        return obj -> g.apply((DBClusterSnapshotAttributesResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dbClusterSnapshotIdentifier;
        private List<DBClusterSnapshotAttribute> dbClusterSnapshotAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DBClusterSnapshotAttributesResult model) {
            this.dbClusterSnapshotIdentifier(model.dbClusterSnapshotIdentifier);
            this.dbClusterSnapshotAttributes(model.dbClusterSnapshotAttributes);
        }

        public final String getDbClusterSnapshotIdentifier() {
            return this.dbClusterSnapshotIdentifier;
        }

        public final void setDbClusterSnapshotIdentifier(String dbClusterSnapshotIdentifier) {
            this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier;
        }

        @Override
        public final Builder dbClusterSnapshotIdentifier(String dbClusterSnapshotIdentifier) {
            this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier;
            return this;
        }

        public final List<DBClusterSnapshotAttribute.Builder> getDbClusterSnapshotAttributes() {
            List<DBClusterSnapshotAttribute.Builder> result = DBClusterSnapshotAttributeListCopier.copyToBuilder(this.dbClusterSnapshotAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbClusterSnapshotAttributes(Collection<DBClusterSnapshotAttribute.BuilderImpl> dbClusterSnapshotAttributes) {
            this.dbClusterSnapshotAttributes = DBClusterSnapshotAttributeListCopier.copyFromBuilder(dbClusterSnapshotAttributes);
        }

        @Override
        public final Builder dbClusterSnapshotAttributes(Collection<DBClusterSnapshotAttribute> dbClusterSnapshotAttributes) {
            this.dbClusterSnapshotAttributes = DBClusterSnapshotAttributeListCopier.copy(dbClusterSnapshotAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterSnapshotAttributes(DBClusterSnapshotAttribute ... dbClusterSnapshotAttributes) {
            this.dbClusterSnapshotAttributes(Arrays.asList(dbClusterSnapshotAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterSnapshotAttributes(Consumer<DBClusterSnapshotAttribute.Builder> ... dbClusterSnapshotAttributes) {
            this.dbClusterSnapshotAttributes(Stream.of(dbClusterSnapshotAttributes).map(c -> (DBClusterSnapshotAttribute)((DBClusterSnapshotAttribute.Builder)DBClusterSnapshotAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DBClusterSnapshotAttributesResult build() {
            return new DBClusterSnapshotAttributesResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DBClusterSnapshotAttributesResult> {
        public Builder dbClusterSnapshotIdentifier(String var1);

        public Builder dbClusterSnapshotAttributes(Collection<DBClusterSnapshotAttribute> var1);

        public Builder dbClusterSnapshotAttributes(DBClusterSnapshotAttribute ... var1);

        public Builder dbClusterSnapshotAttributes(Consumer<DBClusterSnapshotAttribute.Builder> ... var1);
    }
}

