/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.docdb.model.CACertificateIdentifiersListCopier;
import software.amazon.awssdk.services.docdb.model.LogTypeListCopier;
import software.amazon.awssdk.services.docdb.model.UpgradeTarget;
import software.amazon.awssdk.services.docdb.model.ValidUpgradeTargetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DBEngineVersion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DBEngineVersion> {
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(DBEngineVersion.getter(DBEngineVersion::engine)).setter(DBEngineVersion.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(DBEngineVersion.getter(DBEngineVersion::engineVersion)).setter(DBEngineVersion.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> DB_PARAMETER_GROUP_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBParameterGroupFamily").getter(DBEngineVersion.getter(DBEngineVersion::dbParameterGroupFamily)).setter(DBEngineVersion.setter(Builder::dbParameterGroupFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBParameterGroupFamily").build()}).build();
    private static final SdkField<String> DB_ENGINE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBEngineDescription").getter(DBEngineVersion.getter(DBEngineVersion::dbEngineDescription)).setter(DBEngineVersion.setter(Builder::dbEngineDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBEngineDescription").build()}).build();
    private static final SdkField<String> DB_ENGINE_VERSION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBEngineVersionDescription").getter(DBEngineVersion.getter(DBEngineVersion::dbEngineVersionDescription)).setter(DBEngineVersion.setter(Builder::dbEngineVersionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBEngineVersionDescription").build()}).build();
    private static final SdkField<List<UpgradeTarget>> VALID_UPGRADE_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ValidUpgradeTarget").getter(DBEngineVersion.getter(DBEngineVersion::validUpgradeTarget)).setter(DBEngineVersion.setter(Builder::validUpgradeTarget)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidUpgradeTarget").build(), ListTrait.builder().memberLocationName("UpgradeTarget").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpgradeTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpgradeTarget").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXPORTABLE_LOG_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExportableLogTypes").getter(DBEngineVersion.getter(DBEngineVersion::exportableLogTypes)).setter(DBEngineVersion.setter(Builder::exportableLogTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportableLogTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> SUPPORTS_LOG_EXPORTS_TO_CLOUDWATCH_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsLogExportsToCloudwatchLogs").getter(DBEngineVersion.getter(DBEngineVersion::supportsLogExportsToCloudwatchLogs)).setter(DBEngineVersion.setter(Builder::supportsLogExportsToCloudwatchLogs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsLogExportsToCloudwatchLogs").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_CA_CERTIFICATE_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedCACertificateIdentifiers").getter(DBEngineVersion.getter(DBEngineVersion::supportedCACertificateIdentifiers)).setter(DBEngineVersion.setter(Builder::supportedCACertificateIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedCACertificateIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> SUPPORTS_CERTIFICATE_ROTATION_WITHOUT_RESTART_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsCertificateRotationWithoutRestart").getter(DBEngineVersion.getter(DBEngineVersion::supportsCertificateRotationWithoutRestart)).setter(DBEngineVersion.setter(Builder::supportsCertificateRotationWithoutRestart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsCertificateRotationWithoutRestart").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_FIELD, ENGINE_VERSION_FIELD, DB_PARAMETER_GROUP_FAMILY_FIELD, DB_ENGINE_DESCRIPTION_FIELD, DB_ENGINE_VERSION_DESCRIPTION_FIELD, VALID_UPGRADE_TARGET_FIELD, EXPORTABLE_LOG_TYPES_FIELD, SUPPORTS_LOG_EXPORTS_TO_CLOUDWATCH_LOGS_FIELD, SUPPORTED_CA_CERTIFICATE_IDENTIFIERS_FIELD, SUPPORTS_CERTIFICATE_ROTATION_WITHOUT_RESTART_FIELD));
    private static final long serialVersionUID = 1L;
    private final String engine;
    private final String engineVersion;
    private final String dbParameterGroupFamily;
    private final String dbEngineDescription;
    private final String dbEngineVersionDescription;
    private final List<UpgradeTarget> validUpgradeTarget;
    private final List<String> exportableLogTypes;
    private final Boolean supportsLogExportsToCloudwatchLogs;
    private final List<String> supportedCACertificateIdentifiers;
    private final Boolean supportsCertificateRotationWithoutRestart;

    private DBEngineVersion(BuilderImpl builder) {
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.dbParameterGroupFamily = builder.dbParameterGroupFamily;
        this.dbEngineDescription = builder.dbEngineDescription;
        this.dbEngineVersionDescription = builder.dbEngineVersionDescription;
        this.validUpgradeTarget = builder.validUpgradeTarget;
        this.exportableLogTypes = builder.exportableLogTypes;
        this.supportsLogExportsToCloudwatchLogs = builder.supportsLogExportsToCloudwatchLogs;
        this.supportedCACertificateIdentifiers = builder.supportedCACertificateIdentifiers;
        this.supportsCertificateRotationWithoutRestart = builder.supportsCertificateRotationWithoutRestart;
    }

    public final String engine() {
        return this.engine;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final String dbParameterGroupFamily() {
        return this.dbParameterGroupFamily;
    }

    public final String dbEngineDescription() {
        return this.dbEngineDescription;
    }

    public final String dbEngineVersionDescription() {
        return this.dbEngineVersionDescription;
    }

    public final boolean hasValidUpgradeTarget() {
        return this.validUpgradeTarget != null && !(this.validUpgradeTarget instanceof SdkAutoConstructList);
    }

    public final List<UpgradeTarget> validUpgradeTarget() {
        return this.validUpgradeTarget;
    }

    public final boolean hasExportableLogTypes() {
        return this.exportableLogTypes != null && !(this.exportableLogTypes instanceof SdkAutoConstructList);
    }

    public final List<String> exportableLogTypes() {
        return this.exportableLogTypes;
    }

    public final Boolean supportsLogExportsToCloudwatchLogs() {
        return this.supportsLogExportsToCloudwatchLogs;
    }

    public final boolean hasSupportedCACertificateIdentifiers() {
        return this.supportedCACertificateIdentifiers != null && !(this.supportedCACertificateIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> supportedCACertificateIdentifiers() {
        return this.supportedCACertificateIdentifiers;
    }

    public final Boolean supportsCertificateRotationWithoutRestart() {
        return this.supportsCertificateRotationWithoutRestart;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbParameterGroupFamily());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbEngineDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbEngineVersionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidUpgradeTarget() ? this.validUpgradeTarget() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExportableLogTypes() ? this.exportableLogTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsLogExportsToCloudwatchLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedCACertificateIdentifiers() ? this.supportedCACertificateIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsCertificateRotationWithoutRestart());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBEngineVersion)) {
            return false;
        }
        DBEngineVersion other = (DBEngineVersion)obj;
        return Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.dbParameterGroupFamily(), other.dbParameterGroupFamily()) && Objects.equals(this.dbEngineDescription(), other.dbEngineDescription()) && Objects.equals(this.dbEngineVersionDescription(), other.dbEngineVersionDescription()) && this.hasValidUpgradeTarget() == other.hasValidUpgradeTarget() && Objects.equals(this.validUpgradeTarget(), other.validUpgradeTarget()) && this.hasExportableLogTypes() == other.hasExportableLogTypes() && Objects.equals(this.exportableLogTypes(), other.exportableLogTypes()) && Objects.equals(this.supportsLogExportsToCloudwatchLogs(), other.supportsLogExportsToCloudwatchLogs()) && this.hasSupportedCACertificateIdentifiers() == other.hasSupportedCACertificateIdentifiers() && Objects.equals(this.supportedCACertificateIdentifiers(), other.supportedCACertificateIdentifiers()) && Objects.equals(this.supportsCertificateRotationWithoutRestart(), other.supportsCertificateRotationWithoutRestart());
    }

    public final String toString() {
        return ToString.builder((String)"DBEngineVersion").add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("DBParameterGroupFamily", (Object)this.dbParameterGroupFamily()).add("DBEngineDescription", (Object)this.dbEngineDescription()).add("DBEngineVersionDescription", (Object)this.dbEngineVersionDescription()).add("ValidUpgradeTarget", this.hasValidUpgradeTarget() ? this.validUpgradeTarget() : null).add("ExportableLogTypes", this.hasExportableLogTypes() ? this.exportableLogTypes() : null).add("SupportsLogExportsToCloudwatchLogs", (Object)this.supportsLogExportsToCloudwatchLogs()).add("SupportedCACertificateIdentifiers", this.hasSupportedCACertificateIdentifiers() ? this.supportedCACertificateIdentifiers() : null).add("SupportsCertificateRotationWithoutRestart", (Object)this.supportsCertificateRotationWithoutRestart()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "DBParameterGroupFamily": {
                return Optional.ofNullable(clazz.cast(this.dbParameterGroupFamily()));
            }
            case "DBEngineDescription": {
                return Optional.ofNullable(clazz.cast(this.dbEngineDescription()));
            }
            case "DBEngineVersionDescription": {
                return Optional.ofNullable(clazz.cast(this.dbEngineVersionDescription()));
            }
            case "ValidUpgradeTarget": {
                return Optional.ofNullable(clazz.cast(this.validUpgradeTarget()));
            }
            case "ExportableLogTypes": {
                return Optional.ofNullable(clazz.cast(this.exportableLogTypes()));
            }
            case "SupportsLogExportsToCloudwatchLogs": {
                return Optional.ofNullable(clazz.cast(this.supportsLogExportsToCloudwatchLogs()));
            }
            case "SupportedCACertificateIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.supportedCACertificateIdentifiers()));
            }
            case "SupportsCertificateRotationWithoutRestart": {
                return Optional.ofNullable(clazz.cast(this.supportsCertificateRotationWithoutRestart()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBEngineVersion, T> g) {
        return obj -> g.apply((DBEngineVersion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String engine;
        private String engineVersion;
        private String dbParameterGroupFamily;
        private String dbEngineDescription;
        private String dbEngineVersionDescription;
        private List<UpgradeTarget> validUpgradeTarget = DefaultSdkAutoConstructList.getInstance();
        private List<String> exportableLogTypes = DefaultSdkAutoConstructList.getInstance();
        private Boolean supportsLogExportsToCloudwatchLogs;
        private List<String> supportedCACertificateIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private Boolean supportsCertificateRotationWithoutRestart;

        private BuilderImpl() {
        }

        private BuilderImpl(DBEngineVersion model) {
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.dbParameterGroupFamily(model.dbParameterGroupFamily);
            this.dbEngineDescription(model.dbEngineDescription);
            this.dbEngineVersionDescription(model.dbEngineVersionDescription);
            this.validUpgradeTarget(model.validUpgradeTarget);
            this.exportableLogTypes(model.exportableLogTypes);
            this.supportsLogExportsToCloudwatchLogs(model.supportsLogExportsToCloudwatchLogs);
            this.supportedCACertificateIdentifiers(model.supportedCACertificateIdentifiers);
            this.supportsCertificateRotationWithoutRestart(model.supportsCertificateRotationWithoutRestart);
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getDbParameterGroupFamily() {
            return this.dbParameterGroupFamily;
        }

        public final void setDbParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
        }

        @Override
        public final Builder dbParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
            return this;
        }

        public final String getDbEngineDescription() {
            return this.dbEngineDescription;
        }

        public final void setDbEngineDescription(String dbEngineDescription) {
            this.dbEngineDescription = dbEngineDescription;
        }

        @Override
        public final Builder dbEngineDescription(String dbEngineDescription) {
            this.dbEngineDescription = dbEngineDescription;
            return this;
        }

        public final String getDbEngineVersionDescription() {
            return this.dbEngineVersionDescription;
        }

        public final void setDbEngineVersionDescription(String dbEngineVersionDescription) {
            this.dbEngineVersionDescription = dbEngineVersionDescription;
        }

        @Override
        public final Builder dbEngineVersionDescription(String dbEngineVersionDescription) {
            this.dbEngineVersionDescription = dbEngineVersionDescription;
            return this;
        }

        public final List<UpgradeTarget.Builder> getValidUpgradeTarget() {
            List<UpgradeTarget.Builder> result = ValidUpgradeTargetListCopier.copyToBuilder(this.validUpgradeTarget);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValidUpgradeTarget(Collection<UpgradeTarget.BuilderImpl> validUpgradeTarget) {
            this.validUpgradeTarget = ValidUpgradeTargetListCopier.copyFromBuilder(validUpgradeTarget);
        }

        @Override
        public final Builder validUpgradeTarget(Collection<UpgradeTarget> validUpgradeTarget) {
            this.validUpgradeTarget = ValidUpgradeTargetListCopier.copy(validUpgradeTarget);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validUpgradeTarget(UpgradeTarget ... validUpgradeTarget) {
            this.validUpgradeTarget(Arrays.asList(validUpgradeTarget));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validUpgradeTarget(Consumer<UpgradeTarget.Builder> ... validUpgradeTarget) {
            this.validUpgradeTarget(Stream.of(validUpgradeTarget).map(c -> (UpgradeTarget)((UpgradeTarget.Builder)UpgradeTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getExportableLogTypes() {
            if (this.exportableLogTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exportableLogTypes;
        }

        public final void setExportableLogTypes(Collection<String> exportableLogTypes) {
            this.exportableLogTypes = LogTypeListCopier.copy(exportableLogTypes);
        }

        @Override
        public final Builder exportableLogTypes(Collection<String> exportableLogTypes) {
            this.exportableLogTypes = LogTypeListCopier.copy(exportableLogTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportableLogTypes(String ... exportableLogTypes) {
            this.exportableLogTypes(Arrays.asList(exportableLogTypes));
            return this;
        }

        public final Boolean getSupportsLogExportsToCloudwatchLogs() {
            return this.supportsLogExportsToCloudwatchLogs;
        }

        public final void setSupportsLogExportsToCloudwatchLogs(Boolean supportsLogExportsToCloudwatchLogs) {
            this.supportsLogExportsToCloudwatchLogs = supportsLogExportsToCloudwatchLogs;
        }

        @Override
        public final Builder supportsLogExportsToCloudwatchLogs(Boolean supportsLogExportsToCloudwatchLogs) {
            this.supportsLogExportsToCloudwatchLogs = supportsLogExportsToCloudwatchLogs;
            return this;
        }

        public final Collection<String> getSupportedCACertificateIdentifiers() {
            if (this.supportedCACertificateIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedCACertificateIdentifiers;
        }

        public final void setSupportedCACertificateIdentifiers(Collection<String> supportedCACertificateIdentifiers) {
            this.supportedCACertificateIdentifiers = CACertificateIdentifiersListCopier.copy(supportedCACertificateIdentifiers);
        }

        @Override
        public final Builder supportedCACertificateIdentifiers(Collection<String> supportedCACertificateIdentifiers) {
            this.supportedCACertificateIdentifiers = CACertificateIdentifiersListCopier.copy(supportedCACertificateIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedCACertificateIdentifiers(String ... supportedCACertificateIdentifiers) {
            this.supportedCACertificateIdentifiers(Arrays.asList(supportedCACertificateIdentifiers));
            return this;
        }

        public final Boolean getSupportsCertificateRotationWithoutRestart() {
            return this.supportsCertificateRotationWithoutRestart;
        }

        public final void setSupportsCertificateRotationWithoutRestart(Boolean supportsCertificateRotationWithoutRestart) {
            this.supportsCertificateRotationWithoutRestart = supportsCertificateRotationWithoutRestart;
        }

        @Override
        public final Builder supportsCertificateRotationWithoutRestart(Boolean supportsCertificateRotationWithoutRestart) {
            this.supportsCertificateRotationWithoutRestart = supportsCertificateRotationWithoutRestart;
            return this;
        }

        public DBEngineVersion build() {
            return new DBEngineVersion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DBEngineVersion> {
        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder dbParameterGroupFamily(String var1);

        public Builder dbEngineDescription(String var1);

        public Builder dbEngineVersionDescription(String var1);

        public Builder validUpgradeTarget(Collection<UpgradeTarget> var1);

        public Builder validUpgradeTarget(UpgradeTarget ... var1);

        public Builder validUpgradeTarget(Consumer<UpgradeTarget.Builder> ... var1);

        public Builder exportableLogTypes(Collection<String> var1);

        public Builder exportableLogTypes(String ... var1);

        public Builder supportsLogExportsToCloudwatchLogs(Boolean var1);

        public Builder supportedCACertificateIdentifiers(Collection<String> var1);

        public Builder supportedCACertificateIdentifiers(String ... var1);

        public Builder supportsCertificateRotationWithoutRestart(Boolean var1);
    }
}

