/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of <a>DescribeDBSubnetGroups</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDbSubnetGroupsResponse extends DocDbResponse implements
        ToCopyableBuilder<DescribeDbSubnetGroupsResponse.Builder, DescribeDbSubnetGroupsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeDbSubnetGroupsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<DBSubnetGroup>> DB_SUBNET_GROUPS_FIELD = SdkField
            .<List<DBSubnetGroup>> builder(MarshallingType.LIST)
            .memberName("DBSubnetGroups")
            .getter(getter(DescribeDbSubnetGroupsResponse::dbSubnetGroups))
            .setter(setter(Builder::dbSubnetGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DBSubnetGroup")
                            .memberFieldInfo(
                                    SdkField.<DBSubnetGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(DBSubnetGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DBSubnetGroup").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            DB_SUBNET_GROUPS_FIELD));

    private final String marker;

    private final List<DBSubnetGroup> dbSubnetGroups;

    private DescribeDbSubnetGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbSubnetGroups = builder.dbSubnetGroups;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the DBSubnetGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDbSubnetGroups() {
        return dbSubnetGroups != null && !(dbSubnetGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Detailed information about one or more subnet groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDbSubnetGroups} method.
     * </p>
     * 
     * @return Detailed information about one or more subnet groups.
     */
    public final List<DBSubnetGroup> dbSubnetGroups() {
        return dbSubnetGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasDbSubnetGroups() ? dbSubnetGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbSubnetGroupsResponse)) {
            return false;
        }
        DescribeDbSubnetGroupsResponse other = (DescribeDbSubnetGroupsResponse) obj;
        return Objects.equals(marker(), other.marker()) && hasDbSubnetGroups() == other.hasDbSubnetGroups()
                && Objects.equals(dbSubnetGroups(), other.dbSubnetGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDbSubnetGroupsResponse").add("Marker", marker())
                .add("DBSubnetGroups", hasDbSubnetGroups() ? dbSubnetGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "DBSubnetGroups":
            return Optional.ofNullable(clazz.cast(dbSubnetGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbSubnetGroupsResponse, T> g) {
        return obj -> g.apply((DescribeDbSubnetGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DocDbResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDbSubnetGroupsResponse> {
        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Detailed information about one or more subnet groups.
         * </p>
         * 
         * @param dbSubnetGroups
         *        Detailed information about one or more subnet groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSubnetGroups(Collection<DBSubnetGroup> dbSubnetGroups);

        /**
         * <p>
         * Detailed information about one or more subnet groups.
         * </p>
         * 
         * @param dbSubnetGroups
         *        Detailed information about one or more subnet groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSubnetGroups(DBSubnetGroup... dbSubnetGroups);

        /**
         * <p>
         * Detailed information about one or more subnet groups.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.docdb.model.DBSubnetGroup.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.docdb.model.DBSubnetGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.docdb.model.DBSubnetGroup.Builder#build()} is called immediately and
         * its result is passed to {@link #dbSubnetGroups(List<DBSubnetGroup>)}.
         * 
         * @param dbSubnetGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.docdb.model.DBSubnetGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbSubnetGroups(java.util.Collection<DBSubnetGroup>)
         */
        Builder dbSubnetGroups(Consumer<DBSubnetGroup.Builder>... dbSubnetGroups);
    }

    static final class BuilderImpl extends DocDbResponse.BuilderImpl implements Builder {
        private String marker;

        private List<DBSubnetGroup> dbSubnetGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbSubnetGroupsResponse model) {
            super(model);
            marker(model.marker);
            dbSubnetGroups(model.dbSubnetGroups);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<DBSubnetGroup.Builder> getDbSubnetGroups() {
            List<DBSubnetGroup.Builder> result = DBSubnetGroupsCopier.copyToBuilder(this.dbSubnetGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbSubnetGroups(Collection<DBSubnetGroup.BuilderImpl> dbSubnetGroups) {
            this.dbSubnetGroups = DBSubnetGroupsCopier.copyFromBuilder(dbSubnetGroups);
        }

        @Override
        public final Builder dbSubnetGroups(Collection<DBSubnetGroup> dbSubnetGroups) {
            this.dbSubnetGroups = DBSubnetGroupsCopier.copy(dbSubnetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSubnetGroups(DBSubnetGroup... dbSubnetGroups) {
            dbSubnetGroups(Arrays.asList(dbSubnetGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSubnetGroups(Consumer<DBSubnetGroup.Builder>... dbSubnetGroups) {
            dbSubnetGroups(Stream.of(dbSubnetGroups).map(c -> DBSubnetGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeDbSubnetGroupsResponse build() {
            return new DescribeDbSubnetGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
