/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.docdb.DocDbClient;
import software.amazon.awssdk.services.docdb.model.DescribeGlobalClustersRequest;
import software.amazon.awssdk.services.docdb.model.DescribeGlobalClustersResponse;
import software.amazon.awssdk.services.docdb.model.GlobalCluster;

public class DescribeGlobalClustersIterable
implements SdkIterable<DescribeGlobalClustersResponse> {
    private final DocDbClient client;
    private final DescribeGlobalClustersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeGlobalClustersIterable(DocDbClient client, DescribeGlobalClustersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeGlobalClustersResponseFetcher();
    }

    public Iterator<DescribeGlobalClustersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GlobalCluster> globalClusters() {
        Function<DescribeGlobalClustersResponse, Iterator> getIterator = response -> {
            if (response != null && response.globalClusters() != null) {
                return response.globalClusters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeGlobalClustersResponseFetcher
    implements SyncPageFetcher<DescribeGlobalClustersResponse> {
        private DescribeGlobalClustersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeGlobalClustersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeGlobalClustersResponse nextPage(DescribeGlobalClustersResponse previousPage) {
            if (previousPage == null) {
                return DescribeGlobalClustersIterable.this.client.describeGlobalClusters(DescribeGlobalClustersIterable.this.firstRequest);
            }
            return DescribeGlobalClustersIterable.this.client.describeGlobalClusters((DescribeGlobalClustersRequest)((Object)DescribeGlobalClustersIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

