/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.docdb.DocDbAsyncClient;
import software.amazon.awssdk.services.docdb.model.Certificate;
import software.amazon.awssdk.services.docdb.model.DescribeCertificatesRequest;
import software.amazon.awssdk.services.docdb.model.DescribeCertificatesResponse;

public class DescribeCertificatesPublisher
implements SdkPublisher<DescribeCertificatesResponse> {
    private final DocDbAsyncClient client;
    private final DescribeCertificatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeCertificatesPublisher(DocDbAsyncClient client, DescribeCertificatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeCertificatesPublisher(DocDbAsyncClient client, DescribeCertificatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeCertificatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeCertificatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Certificate> certificates() {
        Function<DescribeCertificatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.certificates() != null) {
                return response.certificates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeCertificatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeCertificatesResponseFetcher
    implements AsyncPageFetcher<DescribeCertificatesResponse> {
        private DescribeCertificatesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCertificatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeCertificatesResponse> nextPage(DescribeCertificatesResponse previousPage) {
            if (previousPage == null) {
                return DescribeCertificatesPublisher.this.client.describeCertificates(DescribeCertificatesPublisher.this.firstRequest);
            }
            return DescribeCertificatesPublisher.this.client.describeCertificates((DescribeCertificatesRequest)((Object)DescribeCertificatesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

