/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.docdb.model.DocDbResponse;
import software.amazon.awssdk.services.docdb.model.EventSubscription;
import software.amazon.awssdk.services.docdb.model.EventSubscriptionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEventSubscriptionsResponse
extends DocDbResponse
implements ToCopyableBuilder<Builder, DescribeEventSubscriptionsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeEventSubscriptionsResponse.getter(DescribeEventSubscriptionsResponse::marker)).setter(DescribeEventSubscriptionsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<EventSubscription>> EVENT_SUBSCRIPTIONS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EventSubscriptionsList").getter(DescribeEventSubscriptionsResponse.getter(DescribeEventSubscriptionsResponse::eventSubscriptionsList)).setter(DescribeEventSubscriptionsResponse.setter(Builder::eventSubscriptionsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSubscriptionsList").build(), ListTrait.builder().memberLocationName("EventSubscription").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventSubscription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSubscription").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, EVENT_SUBSCRIPTIONS_LIST_FIELD));
    private final String marker;
    private final List<EventSubscription> eventSubscriptionsList;

    private DescribeEventSubscriptionsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.eventSubscriptionsList = builder.eventSubscriptionsList;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasEventSubscriptionsList() {
        return this.eventSubscriptionsList != null && !(this.eventSubscriptionsList instanceof SdkAutoConstructList);
    }

    public final List<EventSubscription> eventSubscriptionsList() {
        return this.eventSubscriptionsList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventSubscriptionsList() ? this.eventSubscriptionsList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventSubscriptionsResponse)) {
            return false;
        }
        DescribeEventSubscriptionsResponse other = (DescribeEventSubscriptionsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasEventSubscriptionsList() == other.hasEventSubscriptionsList() && Objects.equals(this.eventSubscriptionsList(), other.eventSubscriptionsList());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEventSubscriptionsResponse").add("Marker", (Object)this.marker()).add("EventSubscriptionsList", this.hasEventSubscriptionsList() ? this.eventSubscriptionsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "EventSubscriptionsList": {
                return Optional.ofNullable(clazz.cast(this.eventSubscriptionsList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventSubscriptionsResponse, T> g) {
        return obj -> g.apply((DescribeEventSubscriptionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DocDbResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<EventSubscription> eventSubscriptionsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventSubscriptionsResponse model) {
            super(model);
            this.marker(model.marker);
            this.eventSubscriptionsList(model.eventSubscriptionsList);
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<EventSubscription.Builder> getEventSubscriptionsList() {
            List<EventSubscription.Builder> result = EventSubscriptionsListCopier.copyToBuilder(this.eventSubscriptionsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventSubscriptionsList(Collection<EventSubscription.BuilderImpl> eventSubscriptionsList) {
            this.eventSubscriptionsList = EventSubscriptionsListCopier.copyFromBuilder(eventSubscriptionsList);
        }

        @Override
        public final Builder eventSubscriptionsList(Collection<EventSubscription> eventSubscriptionsList) {
            this.eventSubscriptionsList = EventSubscriptionsListCopier.copy(eventSubscriptionsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSubscriptionsList(EventSubscription ... eventSubscriptionsList) {
            this.eventSubscriptionsList(Arrays.asList(eventSubscriptionsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSubscriptionsList(Consumer<EventSubscription.Builder> ... eventSubscriptionsList) {
            this.eventSubscriptionsList(Stream.of(eventSubscriptionsList).map(c -> (EventSubscription)((EventSubscription.Builder)EventSubscription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeEventSubscriptionsResponse build() {
            return new DescribeEventSubscriptionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DocDbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEventSubscriptionsResponse> {
        public Builder marker(String var1);

        public Builder eventSubscriptionsList(Collection<EventSubscription> var1);

        public Builder eventSubscriptionsList(EventSubscription ... var1);

        public Builder eventSubscriptionsList(Consumer<EventSubscription.Builder> ... var1);
    }
}

