/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.docdb.model.DocDbRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteDbClusterRequest
extends DocDbRequest
implements ToCopyableBuilder<Builder, DeleteDbClusterRequest> {
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterIdentifier").getter(DeleteDbClusterRequest.getter(DeleteDbClusterRequest::dbClusterIdentifier)).setter(DeleteDbClusterRequest.setter(Builder::dbClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build()}).build();
    private static final SdkField<Boolean> SKIP_FINAL_SNAPSHOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SkipFinalSnapshot").getter(DeleteDbClusterRequest.getter(DeleteDbClusterRequest::skipFinalSnapshot)).setter(DeleteDbClusterRequest.setter(Builder::skipFinalSnapshot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkipFinalSnapshot").build()}).build();
    private static final SdkField<String> FINAL_DB_SNAPSHOT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FinalDBSnapshotIdentifier").getter(DeleteDbClusterRequest.getter(DeleteDbClusterRequest::finalDBSnapshotIdentifier)).setter(DeleteDbClusterRequest.setter(Builder::finalDBSnapshotIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalDBSnapshotIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_IDENTIFIER_FIELD, SKIP_FINAL_SNAPSHOT_FIELD, FINAL_DB_SNAPSHOT_IDENTIFIER_FIELD));
    private final String dbClusterIdentifier;
    private final Boolean skipFinalSnapshot;
    private final String finalDBSnapshotIdentifier;

    private DeleteDbClusterRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.skipFinalSnapshot = builder.skipFinalSnapshot;
        this.finalDBSnapshotIdentifier = builder.finalDBSnapshotIdentifier;
    }

    public final String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public final Boolean skipFinalSnapshot() {
        return this.skipFinalSnapshot;
    }

    public final String finalDBSnapshotIdentifier() {
        return this.finalDBSnapshotIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.skipFinalSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(this.finalDBSnapshotIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDbClusterRequest)) {
            return false;
        }
        DeleteDbClusterRequest other = (DeleteDbClusterRequest)((Object)obj);
        return Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.skipFinalSnapshot(), other.skipFinalSnapshot()) && Objects.equals(this.finalDBSnapshotIdentifier(), other.finalDBSnapshotIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteDbClusterRequest").add("DBClusterIdentifier", (Object)this.dbClusterIdentifier()).add("SkipFinalSnapshot", (Object)this.skipFinalSnapshot()).add("FinalDBSnapshotIdentifier", (Object)this.finalDBSnapshotIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterIdentifier()));
            }
            case "SkipFinalSnapshot": {
                return Optional.ofNullable(clazz.cast(this.skipFinalSnapshot()));
            }
            case "FinalDBSnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.finalDBSnapshotIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDbClusterRequest, T> g) {
        return obj -> g.apply((DeleteDbClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DocDbRequest.BuilderImpl
    implements Builder {
        private String dbClusterIdentifier;
        private Boolean skipFinalSnapshot;
        private String finalDBSnapshotIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDbClusterRequest model) {
            super(model);
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.skipFinalSnapshot(model.skipFinalSnapshot);
            this.finalDBSnapshotIdentifier(model.finalDBSnapshotIdentifier);
        }

        public final String getDbClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final Boolean getSkipFinalSnapshot() {
            return this.skipFinalSnapshot;
        }

        @Override
        public final Builder skipFinalSnapshot(Boolean skipFinalSnapshot) {
            this.skipFinalSnapshot = skipFinalSnapshot;
            return this;
        }

        public final void setSkipFinalSnapshot(Boolean skipFinalSnapshot) {
            this.skipFinalSnapshot = skipFinalSnapshot;
        }

        public final String getFinalDBSnapshotIdentifier() {
            return this.finalDBSnapshotIdentifier;
        }

        @Override
        public final Builder finalDBSnapshotIdentifier(String finalDBSnapshotIdentifier) {
            this.finalDBSnapshotIdentifier = finalDBSnapshotIdentifier;
            return this;
        }

        public final void setFinalDBSnapshotIdentifier(String finalDBSnapshotIdentifier) {
            this.finalDBSnapshotIdentifier = finalDBSnapshotIdentifier;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteDbClusterRequest build() {
            return new DeleteDbClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DocDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteDbClusterRequest> {
        public Builder dbClusterIdentifier(String var1);

        public Builder skipFinalSnapshot(Boolean var1);

        public Builder finalDBSnapshotIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

