/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.docdb.DocDbAsyncClient;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterParametersRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterParametersResponse;
import software.amazon.awssdk.services.docdb.model.Parameter;

public class DescribeDBClusterParametersPublisher
implements SdkPublisher<DescribeDbClusterParametersResponse> {
    private final DocDbAsyncClient client;
    private final DescribeDbClusterParametersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDBClusterParametersPublisher(DocDbAsyncClient client, DescribeDbClusterParametersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDBClusterParametersPublisher(DocDbAsyncClient client, DescribeDbClusterParametersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDbClusterParametersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDbClusterParametersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Parameter> parameters() {
        Function<DescribeDbClusterParametersResponse, Iterator> getIterator = response -> {
            if (response != null && response.parameters() != null) {
                return response.parameters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeDbClusterParametersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeDbClusterParametersResponseFetcher
    implements AsyncPageFetcher<DescribeDbClusterParametersResponse> {
        private DescribeDbClusterParametersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbClusterParametersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeDbClusterParametersResponse> nextPage(DescribeDbClusterParametersResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBClusterParametersPublisher.this.client.describeDBClusterParameters(DescribeDBClusterParametersPublisher.this.firstRequest);
            }
            return DescribeDBClusterParametersPublisher.this.client.describeDBClusterParameters((DescribeDbClusterParametersRequest)((Object)DescribeDBClusterParametersPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

